/*
 * Remote Laboratory Instrumentation Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2009 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <getopt.h>
#include "gpib/ib.h"

char falpha[1024];

const char * scopeLongDescription (const char * scopeType) {
	if (strcmp("HP54600OS", scopeType) == 0) {
		return "Hewlett Packard 54600 series";
	}
	else if (strcmp("TDS744AOS", scopeType) == 0) {
		return "Tektronix 744A series";
	}
	else if (strcmp("TDS744COS", scopeType) == 0) {
		return "Tektronix 744C series";
	}
	else {
		return "UNKNOWN";
	}
}

const char * commanalyzerLongDescription (const char * commanalyzerType) {
	if (strcmp("HP8924C", commanalyzerType) == 0) {
		return "Hewlett Packard 8924 series";
	}
	else {
		return "UNKNOWN";
	}
}

const char * companalyzerLongDescription (const char * companalyzerType) {
	if (strcmp("HP4191A", companalyzerType) == 0) {
		return "Hewlett Packard HP4191 series";
	}
	else {
		return "UNKNOWN";
	}
}

const char * funcgenLongDescription (const char * funcgenType) {
	if (strcmp("AG33250A", funcgenType) == 0) {
		return "Agilent AG33250A";
	}
	else {
		return "UNKNOWN";
	}
}

/* returns a device descriptor after prompting user for primary address */
int open_gpib_device(int minor, int pad) {
	int ud;
	const int sad = 0;
	const int send_eoi = 1;
	const int eos_mode = 0;
	const int timeout = T1s;

	printf("[INFO] Trying to open GPIB device %i on board /dev/gpib%i...\n\r", pad, minor);
	ud = ibdev(minor, pad, sad, timeout, send_eoi, eos_mode);
	if(ud < 0)
	{
		printf("[WARN] GPIB interface error\n\r");
		return -1;
	}

	return ud;
}

int gpib_write(int ud, const char * buffer) {
	if( ibwrt(ud, buffer, strlen(buffer)) & ERR )
	{
		return -1;
	}
	return 0;
}

int gpib_read_array(int ud, int max_num_bytes, char * segarray) {
	int br;

	ibrd(ud, segarray, max_num_bytes-1);
	br = ThreadIbcntl();

	#ifdef ENABLE_EXTRA_DEBUGGING
	printf("[DEBG] Number of bytes read from GPIB device: %li\n", br);
	#endif
	if ((ThreadIbsta() & ERR) && (br == 0)) {
		return -1;
	}
	return br;
}

int gpib_read_binary(int ud, int max_num_bytes) {
	#ifdef ENABLE_EXTRA_DEBUGGING
	printf("[DEBG] Trying to read %i bytes from GPIB device...\n", max_num_bytes);
	#endif

	//ibrd(ud, scope_raw_screenshot_data, max_num_bytes-1);
	system("rm -f /tmp/current_scope_screenshot.bmp");
	ibrdf(ud, "/tmp/current_scope_screenshot.bmp");
	#ifdef ENABLE_EXTRA_DEBUGGING
	printf("[DEBG] Number of bytes read from GPIB device: %li\n", ThreadIbcntl());
	#endif
	if (ThreadIbsta() & ERR) {
		return -1;
	}
	return 0;
}
