/*
 * Remote Laboratory Logic Analyzer Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2014 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_LOGICANALYZERPART_H
#define REMOTELAB_LOGICANALYZERPART_H

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

#include <tqtrla.h>

#define MAXTRACES 255

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQRectF;
class TQGridLayout;
class TQCheckBox;
class TQGroupBox;
class LogicAnalyzerBase;

namespace RemoteLab
{
	class LogicAnalyzerPart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			LogicAnalyzerPart( QWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~LogicAnalyzerPart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		public slots:
			virtual bool openURL(const KURL &url);
		
		private slots:
			void postInit();
			void processLockouts();
			void updateGraticule();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);
			void mainEventLoop();
			void startDAQ();
			void stopDAQ();
			void startLogicAnalyzer();
			void stopLogicAnalyzer();
			void saveWaveforms();
			void recallWaveforms();
			virtual void postProcessTrace();
	
		private:
			TraceWidget* m_traceWidget;
			TQGridLayout* m_traceControlWidgetGrid;
			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerCommandState;
			TQTimer* m_forcedUpdateTimer;
			TQTimer* m_updateTimeoutTimer;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;
			TQ_INT16 m_maxNumberOfTraces;
			TQ_INT32 m_currentOpChannel;
			TQ_INT32 m_nextOpChannel;
			TQ_INT16 m_nextOpParameter16;
			TQ_INT16 m_hdivs;
			TQ_INT16 m_vdivs;
			bool m_running;
			TQ_INT32 m_samplesInTrace[MAXTRACES+1];
			bool m_channelActive[MAXTRACES+1];
			TQString m_channelName[MAXTRACES+1];
			double m_voltsDiv[MAXTRACES+1];
			double m_secsDiv[MAXTRACES+1];
			bool m_runningSet;
			bool m_voltsDivSet[MAXTRACES+1];
			bool m_channelActiveSet[MAXTRACES+1];
			bool m_lastChangesRequireFullUpdate;
			LogicAnalyzerBase* m_base;
			TQMutex* m_instrumentMutex;
			bool stopTraceUpdate;
	};
}

#endif
