/*
 * Remote Laboratory Communications Analyzer Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_COMMANALYZERPART_H
#define REMOTELAB_COMMANALYZERPART_H

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

#include <tqtrla.h>

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQRectF;
class CommAnalyzerBase;

namespace RemoteLab
{
	class CommAnalyzerPart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			CommAnalyzerPart( QWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~CommAnalyzerPart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		public slots:
			virtual bool openURL(const KURL &url);
			void updateZoomWidgetLimits(const TQRectF& zoomRect);
		
		private slots:
			void postInit();
			void processLockouts();
			void updateGraticule();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);
			void mainEventLoop();
			virtual void postProcessTrace();
			void saRefLevelChanged(double);
	
		private:
			TraceWidget* m_traceWidget;
			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerCommandState;
			TQTimer* m_forcedUpdateTimer;
			TQTimer* m_updateTimeoutTimer;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;
			TQ_INT16 m_samplesInTrace;
			double m_leftFrequency;
			double m_rightFrequency;
			TQ_INT16 m_hdivs;
			TQ_INT16 m_vdivs;
			double m_centerfreq;
			double m_spanfreq;
			double m_rpower;
			double m_vscale;
			CommAnalyzerBase* m_base;
			TQMutex* m_instrumentMutex;
			bool stopTraceUpdate;
	};
}

#endif
