/***************************************************************************
 *   Copyright (C) 2013 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tdeconfig.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

#include "groupauthdlgbase.h"
#include "groupauthdlg.h"

TQListBoxKeyedText::TQListBoxKeyedText(TQListBox* listbox, const TQString & text, const TQ_UINT32 key) : TQListBoxText(listbox, text), m_key(key) {
	//
}

TQListBoxKeyedText::TQListBoxKeyedText(const TQString & text, const TQ_UINT32 key)  : TQListBoxText(text), m_key(key) {
	//
}

TQListBoxKeyedText::TQListBoxKeyedText(TQListBox* listbox, const TQString & text, const TQ_UINT32 key, TQListBoxItem *after) : TQListBoxText(listbox, text, after), m_key(key) {
	//
}

TQListBoxKeyedText::~TQListBoxKeyedText() {
	//
}

TQ_UINT32 TQListBoxKeyedText::key() {
	return m_key;
}

GroupPermissionsDialog::GroupPermissionsDialog(TQWidget* parent, const char* name)
	: KDialogBase(parent, name, true, i18n("Manage Permissions"), Ok|Cancel, Ok, true)
{
	m_base = new GroupPermissionsDlgBase(this);
	m_base->permissionsSelector->availableListBox()->setSelectionMode(TQListBox::Multi);
	m_base->permissionsSelector->selectedListBox()->setSelectionMode(TQListBox::Multi);

	setMainWidget(m_base);

	connect(m_base->m_groupName, SIGNAL(textChanged(const TQString&)), this, SLOT(processLockouts()));
	m_base->m_groupName->setFocus();

	processLockouts();
}

void GroupPermissionsDialog::processLockouts() {
	if (m_base->m_groupName->text() != "") {
		enableButtonOK(true);
	}
	else {
		enableButtonOK(false);
	}
}

void GroupPermissionsDialog::setGroupName(TQString name, bool editable) {
	m_base->m_groupName->setText(name);
	m_base->m_groupName->setEnabled(editable);
}

TQString GroupPermissionsDialog::groupName() {
	return m_base->m_groupName->text();
}

void GroupPermissionsDialog::setPermissionsSelectorLabel(TQString label) {
	m_base->groupPermissionsSelector->setTitle(label);
}

void GroupPermissionsDialog::setAvailableServers(TQKeyedStringList list) {
	TQListBox* availableListBox = m_base->permissionsSelector->availableListBox();
	for (TQKeyedStringList::Iterator it = list.begin(); it != list.end(); ++it) {
		new TQListBoxKeyedText(availableListBox, (*it).first, (*it).second);
	}
	availableListBox->sort(true);
}

void GroupPermissionsDialog::setSelectedServers(TQKeyedStringList list) {
	TQListBox* availableListBox = m_base->permissionsSelector->availableListBox();
	TQListBox* selectedListBox = m_base->permissionsSelector->selectedListBox();
	for (TQKeyedStringList::Iterator it = list.begin(); it != list.end(); ++it) {
		TQListBoxItem* item = availableListBox->findItem((*it).first, ExactMatch);
		if (item) {
			delete item;
		}
		new TQListBoxKeyedText(selectedListBox, (*it).first, (*it).second);
	}
	availableListBox->sort(true);
	selectedListBox->sort(true);
}

TQKeyedStringList GroupPermissionsDialog::selectedServers() {
	TQKeyedStringList list;
	TQListBox* selectedListBox = m_base->permissionsSelector->selectedListBox();
	TQListBoxItem* item = selectedListBox->firstItem();
	while (item) {
		TQListBoxKeyedText* item2 = dynamic_cast<TQListBoxKeyedText*>(item);
		if (item2) {
			list.append(TQKeyedStringPair(item2->text(), item2->key()));
		}
		item = item->next();
	}
	return list;
}

void GroupPermissionsDialog::setSessionLimit(int limit, bool visible) {
	if (visible) {
		m_base->m_sessionLimitLabel->show();
		m_base->m_sessionLimit->show();
	}
	else {
		m_base->m_sessionLimitLabel->hide();
		m_base->m_sessionLimit->hide();
	}

	m_base->m_sessionLimit->setValue(limit);
}

int GroupPermissionsDialog::sessionLimit() {
	return m_base->m_sessionLimit->value();
}

void GroupPermissionsDialog::slotOk() {
	accept();
}

#include "groupauthdlg.moc"
