//Author:    Timothy Pearson <kb9vqf@pearsoncomputing.net>, (C) 2012
//Copyright: See COPYING file that comes with this distribution

#ifndef _REMOTEMDI_H_
#define _REMOTEMDI_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqvaluelist.h>
#include <tdemdimainfrm.h>

#include <tdekrbclientsocket.h>

#include <tqtrla.h>

#define MAGIC_NUMBER 1
#define PROTOCOL_VERSION 1

class KMdiChildView;
class TDEListBox;
class TQListBoxItem;
class TDEToggleAction;

/**
 * @short Remote Laboratory Main Window
 * @author Timothy Pearson <kb9vqf@pearsoncomputing.net>
 * @version 0.1
 */
class RemoteMDI : public KMdiMainFrm
{
	Q_OBJECT

	public:
		/**
		* Default Constructor
		*/
		RemoteMDI();
		
		/**
		* Default Destructor
		*/
		virtual ~RemoteMDI();

		void setServerHost(TQString server);

	public slots:
		virtual void childWindowCloseRequest(KMdiChildView *pWnd);
	
	protected slots:
		void openNewWindow(KMdiChildView *view=0);
		void currentChanged(KMdiChildView *current);
		void closeCurrent();
		void closeSpecifiedWindow(KMdiChildView *window);
		void childClosed(KMdiChildView *w);
	
	private slots:
		void configToolbars();
		void configKeys();
		void updateStatusBarMessage();
		void updateStatusBarMainMessage(const TQString& message);
		void updateStatusBarWindowMessage(const TQString& message, const TQObject* window=NULL);
		void connectToServer();
		void finishConnectingToServer();
		void disconnectFromServer();
		void promptForStationType();
		void connectionClosedHandler();
		void processLockouts();
		void processActions();
		void startModule();
		void masterPoll();
	
	protected:
		virtual bool queryClose();
		virtual void resizeEvent(TQResizeEvent *);

	private:
		int getNewTicket();

	private:
		TQString m_mainStatusBarMessage;
		TQMap<const TQObject*, TQString> m_windowStatusBarMapping;

		unsigned m_children;
		TQString m_serverHost;

		TDEKerberosClientSocket* m_rsvSvrSocket;

		bool connToServerConnecting;
		int connToServerState;
		TQTimer *connToServerTimeoutTimer;
		TQTimer *masterPollTimer;

		TDEAction *connect_action;
		TDEAction *disconnect_action;
		TQPtrList<TDEAction> m_instrumentActionList;
		StationType m_activeStation;
};

#endif // _REMOTEMDI_H_

