/*
 * Remote Laboratory Protocol Terminal Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2014 - 2015 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_PROTOTERMINALPART_H
#define REMOTELAB_PROTOTERMINALPART_H

#include <ntqthread.h>
#include <ntqeventloop.h>

#include <tqvariant.h>
#include <tqvaluevector.h>

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

#include <tqtrla.h>

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQRectF;
class ProtoTerminalBase;

namespace RemoteLab
{
	typedef enum ProtoTerminalEventType {
		ConsoleTextReceive =	0,
		ConsoleTextSend =	1,
		TxRxSyncPoint = 	2
	} ProtoTerminalEventType;

	typedef TQPair<ProtoTerminalEventType, TQVariant> ProtoTerminalEvent;
	typedef TQValueVector<ProtoTerminalEvent> ProtoTerminalEventQueue;

	class ProtoTerminalWorker : public TQObject
	{
		TQ_OBJECT

		public:
			ProtoTerminalWorker();
			~ProtoTerminalWorker();

		signals:
			void outboundQueueUpdated();

		public slots:
			void run();
			void wake();
			void dataReceived();
	
		public:
			void appendItemToInboundQueue(ProtoTerminalEvent item, bool syncPoint=false);
			bool syncPointActive();
			void lockOutboundQueue();
			void unlockOutboundQueue();
			ProtoTerminalEventQueue* outboundQueue();

		public:
			TDEKerberosClientSocket* m_socket;
			TQMutex* m_instrumentMutex;

		private:
			ProtoTerminalEventQueue m_outboundQueue;
			ProtoTerminalEventQueue m_inboundQueue;
			TQMutex* m_outboundQueueMutex;
			TQMutex* m_inboundQueueMutex;
			TQMutex* m_networkDataMutex;
			bool m_newData;
	};

	class ProtoTerminalPart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			ProtoTerminalPart( QWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~ProtoTerminalPart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		signals:
			void wakeWorkerThread();

		public slots:
			virtual bool openURL(const KURL &url);
			void processOutboundQueue();
		
		private slots:
			void postInit();
			void processLockouts();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);
			void networkTick();
			void networkTimeout();
			void sendTextClicked();
	
		private:
			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerCommandState;
			TQTimer* m_updateTimeoutTimer;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;
			ProtoTerminalBase* m_base;
			TQMutex* m_instrumentMutex;
			TQString m_TextToSend;

			ProtoTerminalWorker* m_worker;
			TQEventLoopThread* m_workerThread;
	};
}

#endif
