/*
 * Remote Laboratory Workspaces Client
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2014 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include "define.h"
#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kinputdialog.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kurl.h>
#include <tdeconfig.h>
#include "remotemdi.h"

static const TDECmdLineOptions options[] =
{
	{ "+[server]", I18N_NOOP( "Connect to remote server 'server'" ), 0 },
	{ 0, 0, 0 }
};

static TDEAboutData about(
	APP_NAME, I18N_NOOP( APP_PRETTYNAME ), APP_VERSION,
	I18N_NOOP("uLab Remote Laboratory Workspaces Graphical Client"), TDEAboutData::License_GPL_V2,
	I18N_NOOP("(C) 2012-2014 Timothy Pearson"), 0,
	"https://ulab.trinitydesktop.org/", "kb9vqf@pearsoncomputing.net" );


int main(int argc, char *argv[])
{
	about.addAuthor("Timothy Pearson", I18N_NOOP("Author, maintainer"), "kb9vqf@pearsoncomputing.net", "https://ulab.trinitydesktop.org/");

	TDECmdLineArgs::init(argc, argv, &about);
	TDECmdLineArgs::addCmdLineOptions(options);

	TDEApplication app;

	// Read MDI settings (window positions, etc)
	// FIXME
	TDEConfig *c = app.config();

	// Create main window
	RemoteMDI *mainWin = new RemoteMDI();
	app.setMainWidget(mainWin);

	TDECmdLineArgs* const args = TDECmdLineArgs::parsedArgs();
	if (args->count() > 0) {
		mainWin->setServerHost(args->arg(0));
	}
	else {
		bool accepted;
		TQString serverHost = KInputDialog::getText(i18n("Enter server FQDN"), i18n("Please enter the FQDN of the desired remote laboratory server below"), "", &accepted);
		if (accepted) {
			if (serverHost != "") {
				mainWin->setServerHost(serverHost);
			}
			else {
				return -1;
			}
		}
		else {
			return -1;
		}
	}
	args->clear();

	mainWin->show();

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
}
