# Copyright 2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"

TRINITY_MODULE_TYPE="applications/themes"
inherit trinity-base-2

DESCRIPTION="Ia Ora widget style for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="gtk"

DEPEND="
	gtk? ( x11-libs/gtk+:2 )
"
RDEPEND="$DEPEND"

src_configure() {
	local mycmakeargs=(
		-DBUILD_GTK_ENGINE=$(usex gtk)
	)
	trinity-base-2_src_configure
}

src_install () {
	trinity-base-2_src_install

	if use gtk; then
		rm -r "${ED}/usr/$(get_libdir)/gtk-2.0"/*/engines/libia_ora.la || die
	fi
}
