# Copyright 2023-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="optional"

TRINITY_LANGS="af ar be bg br bs ca csb cs cy da de el es et \
		fi fr ga gl he hi hu it ja ka lt mk nb nl pa \
		pt_BR pt ru rw sk sr sv ta th tr uk xh zh_CN \
		zh_TW zu"

TRINITY_DOC_LANGS="da de es et fr it nl pt ru sv"

TRINITY_MODULE_TYPE="applications/multimedia"
inherit trinity-base-2 optfeature

DESCRIPTION="MPlayer - a simple media player for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="cairo expat gstreamer koffice npp xine xv +xtest"

DEPEND="
	x11-libs/libX11
	x11-libs/libXv
	x11-libs/libXext
	expat? (
		dev-libs/expat
	)
	cairo? (
		x11-libs/cairo
	)
	gstreamer? (
		media-libs/gstreamer:1.0
		media-libs/gst-plugins-base:1.0
	)
	npp? (
		sys-apps/dbus
		dev-libs/dbus-glib
		x11-libs/gtk+:2
		dev-libs/glib:2
		dev-libs/nspr
	)
	xine? (
		media-libs/xine-lib
		x11-libs/libXext
	)
	koffice? ( ~trinity-apps/koffice-libs-${PV} )
"
# NOTE: xv dependencies are forced in <=14.1.4
RDEPEND="${DEPEND}
	media-video/mplayer
	gstreamer? ( media-plugins/gst-plugins-meta )
"

src_configure() {
	local mycmakeargs=(
		-DWITH_XTEST="$(usex xtest)"
		-DWITH_CAIRO="$(usex cairo)"
		-DWITH_EXPAT="$(usex expat)"

		-DBUILD_KGSTPLAYER="$(usex gstreamer)"
		-DBUILD_KNPPLAYER="$(usex npp)"
		-DBUILD_KXINEPLAYER="$(usex xine)"
		-DBUILD_KXVPLAYER="$(usex xv)"

		-DBUILD_KOFFICE_PLUGIN="$(usex koffice)"
	)
	trinity-base-2_src_configure
}

pkg_postinst() {
	optfeature "broadcast recording" media-video/ffmpeg
}
