# Copyright 1999-2022 Gentoo Authors and Martin V\"ath
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

inherit toolchain-funcs

DESCRIPTION="fast screen-oriented spelling checker"
HOMEPAGE="https://www.cs.hmc.edu/~geoff/ispell.html"
SRC_URI="https://www.cs.hmc.edu/~geoff/tars/${P}.tar.gz"

LICENSE="HPND"
SLOT="0/${PV}"
KEYWORDS="~alpha amd64 ~arm hppa ~mips ppc sparc x86 ~amd64-linux ~x86-linux ~ppc-macos"
IUSE="+tinfo"

# Don't use Gentoo mirrors
RESTRICT="mirror"

RDEPEND="
	sys-apps/miscfiles
	sys-libs/ncurses:0=[tinfo=]
"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}/${P}-fix-DESTDIR.patch"
)

src_prepare() {
	default

	# Avoid stripping binaries
	sed -i -e '/^\s*strip/d' Makefile deformatters/Makefile nextispell/Makefile

	sed -i \
		-e 's:/usr/local/man:'"${EPREFIX}"'/usr/share/man:' \
		-e 's:/usr/local/lib:'"${EPREFIX}"'/usr/'"$(get_libdir)/${PN}:" \
		-e 's:/usr/local:'"${EPREFIX}"'/usr:' \
		-- local.h.* || die
}

src_configure() {
	local sed_opts=(
		-e 's:\(^#define CC\).*:\1 "'"$(tc-getCC)"'":'
		-e 's:\(^#define CFLAGS\).*:\1 "'"${CFLAGS}"'":'
	)
	use tinfo && sed_opts+=( -e 's:\(^#define TERMLIB\).*:\1 "-ltinfo":' )
	sed -i "${sed_opts[@]}" -- config.X || die

	emake -j1 config.sh
}

src_compile() {
	emake -j1
}

src_install() {
	emake -j1 install DESTDIR="$D"
	einstalldocs
}
