# Copyright 1999-2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

inherit autotools

MY_PV="pre${PV%_pre*}-${PV#*_pre}"

DESCRIPTION="Library and applications to access GSM mobile phones"
HOMEPAGE="https://web.archive.org/web/20080714224238/http://www.pxh.de/fs/gsmlib/"
SRC_URI="https://github.com/Fat-Zer/${PN}/archive/refs/tags/${MY_PV}.tar.gz -> ${PN}-${MY_PV}.tar.gz"

S="${WORKDIR}/${PN}-${MY_PV}"

LICENSE="LGPL-2"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~ppc ~ppc64 ~sparc ~x86"

# Don't use Gentoo mirrors
RESTRICT="mirror"

src_prepare() {
	default

	eautoreconf
}

src_install() {
	default

	rm "${ED}/usr/$(get_libdir)/"*.la || die
}
