/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _FILEGROUPSWIDGET_H_
#define _FILEGROUPSWIDGET_H_

#include <tdelistview.h>

class FileGroupsPart;
class KDevProject;


class FileGroupsWidget : public TDEListView
{
    TQ_OBJECT
  
    
public:
    FileGroupsWidget(FileGroupsPart *part);
    ~FileGroupsWidget();
    
public slots:
    void refresh();
    void addFiles ( const TQStringList& fileList );
    void removeFiles ( const TQStringList& fileList );

private slots:
    void slotItemExecuted(TQListViewItem *item);
    void slotContextMenu(TDEListView *, TQListViewItem *item, const TQPoint &p);
    void slotToggleShowNonProjectFiles();
    void slotToggleDisplayLocation();
    
protected:
    void addFile(const TQString &fileName);
    void removeFile(const TQString &fileName);

private:
    TQStringList allFilesRecursively( TQString const & );
    FileGroupsPart *m_part;

    class TDEToggleAction *m_actionToggleShowNonProjectFiles;
    class TDEToggleAction *m_actionToggleDisplayLocation;
    int LocationID;
};

#endif

