/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <tqpushbutton.h>
#include <tqstylesheet.h>

#include <tdeapplication.h>
#include <tdeglobalsettings.h>
#include <kcompletion.h>
#include <tdelocale.h>
#include <tdeglobal.h>

#include "ksv_conf.h"
#include "ksvdraglist.h"
#include "ksv_service.h"
#include "ksv_core.h"

const int ksv::runlevelNumber = 7;
TDEAboutData* ksv::about = 0L;

bool ksv::getServiceDescription (const TQString& path, TQString& res)
{
  KSVService* tmp = KSVService::newService (path, KSVConfig::self()->runlevelPath());
  res = i18n ("No description available.");
  bool result = false;

  if (tmp)
    {
      res = tmp->description();
      result = true;
    }

  delete tmp;

  return result;
}

TQString ksv::breakWords (const TQString& s, int amount)
{
  TQString res;

  int left = s.length();
  int maximum = amount;
  TQString str = s;

  while (left > maximum)
    {
      int pos = -1;
      for (int i = 1; i < amount; ++i)
        {
          if ((pos = str.find(' ', amount - i, false)) < 0 || (pos > maximum + i))
            continue;
          else
            break;
        }
      
      if (pos == -1) break;  //handles case when no spaces
      
      maximum = kMax (maximum, pos);
      res += str.left(pos) + "\n";
      left += -pos - 1;
      str = str.right(left);
    }
  
  res += str;
  
  return res;
}

const TQString& ksv::copyrightSymbol ()
{
  static TQString c = TQString::fromUtf8 ("©");

  return c;
}

TQStyleSheet* ksv::styleSheet ()
{
  static TQStyleSheet style;
  static bool initialized = false;

  if (!initialized)
	{
	  TQStyleSheetItem* item = new TQStyleSheetItem (&style, "vip"); // very important
	  item->setLogicalFontSize (5);
	  item->setFontWeight (TQFont::Bold);
      item->setDisplayMode (TQStyleSheetItem::DisplayBlock);

	  item = new TQStyleSheetItem (&style, "rl"); // runlevel
	  item->setLogicalFontSize (4);
	  item->setFontWeight (TQFont::Bold);
//       item->setDisplayMode (TQStyleSheetItem::DisplayBlock);

	  item = new TQStyleSheetItem (&style, "start"); // start section
	  item->setColor (TQt::green);
//       item->setContexts ("rl");

	  item = new TQStyleSheetItem (&style, "stop"); // stop section
	  item->setColor (TQt::red);
//       item->setContexts ("rl");

	  item = new TQStyleSheetItem (&style, "error"); // signal an error
	  item->setColor (TQt::red);
	  item->setLogicalFontSizeStep (1);

	  item = new TQStyleSheetItem (&style, "cmd"); // command line
	  item->setFontFamily (TDEGlobalSettings::fixedFont().family());
	}

  return &style;
}

TDECompletion* ksv::serviceCompletion ()
{
  static TDECompletion comp;  

  return &comp;
}

TDECompletion* ksv::numberCompletion ()
{
  static TDECompletion comp;
  static bool initialized = false;
  
  if (!initialized)
    {
      for (int value = 0; value < 100; value += 10)
        {
          TQString result = TQString::number (value);

          if (value < 10)
            result.sprintf("%.2i", value);
          
          comp.addItem (result);
        }
    }

  return &comp;
}

const TQString& ksv::logFileFilter ()
{
  static TQString filter = "*" + ksv::logFileExtension() + "|" +
    TQString(kapp->caption() + i18n(" log files") + " (*" + ksv::logFileExtension() + ")");
  
  return filter;
}

const TQString& ksv::nativeFileFilter ()
{
  static TQString filter = "*" + ksv::nativeFileExtension() + "|"
    + i18n("Saved Init Configurations") + " (*" + ksv::nativeFileExtension() + ")";
  
  return filter;
}

const TQString& ksv::logFileExtension ()
{
  static TQString ext = ".ksysv_log";
  
  return ext;
}

const TQString& ksv::nativeFileExtension ()
{
  static TQString ext = ".ksysv";
  
  return ext;
}

const char* ksv::notifications[] =
{
  "Show Runlevels ReadOnly",
  "Show Could Not Generate Sorting Number"
};
