/***************************************************************************
                          kcmkuick.cpp - control module for kuick
                             -------------------
    copyright            : (C) 2001 by Holger Freyther <freyther@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.        *
 *                                                                         *
 ***************************************************************************/

#include "kcmkuick.h"

#include <tqlayout.h>
#include <tqfile.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <kstandarddirs.h>
#include <kservice.h>

#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <tqspinbox.h>
#include <tqstring.h>

typedef KGenericFactory<KCMKuick, TQWidget> KuickFactory;
K_EXPORT_COMPONENT_FACTORY ( kcm_kuick, KuickFactory( "kcmkuick" ) )

KCMKuick::KCMKuick(TQWidget *parent, const char *name, const TQStringList &)
:TDECModule(parent, name)
{
    TDEAboutData *ab=new TDEAboutData( "kcmkuick", I18N_NOOP("KCM Kuick"),
       "0.2",I18N_NOOP("KControl module for Kuick's configuration"), TDEAboutData::License_GPL,
       "(c) 2001, Holger Freyther", 0, 0, "freyther@kde.org");
    ab->addAuthor("Holger Freyther",0, "freyther@kde.org");
    setAboutData( ab );

    TQVBoxLayout *topLayout = new TQVBoxLayout(this, 0, 0);
    dialog = new KCMKuickDialog(this);
    topLayout->add(dialog);
    topLayout->addStretch();

    connect( dialog->m_sbCopy, TQ_SIGNAL(valueChanged(int) ), TQ_SLOT(configChanged() ) );
    connect( dialog->m_sbMove, TQ_SIGNAL(valueChanged(int) ), TQ_SLOT(configChanged() ) );
    connect( dialog->pbCopyClear, TQ_SIGNAL(pressed() ), TQ_SLOT(slotClearCopyCache() ) );
    connect( dialog->pbMoveClear, TQ_SIGNAL(pressed() ), TQ_SLOT(slotClearMoveCache() ) );
    connect( dialog->m_chkShow, TQ_SIGNAL(clicked() ), TQ_SLOT(slotShowToggled() ) );
    
    load();
}

void KCMKuick::slotShowToggled()
{
    bool showChecked = dialog->m_chkShow->isChecked();
    dialog->m_grpCopy->setEnabled( showChecked );
    dialog->m_grpMove->setEnabled( showChecked );
    configChanged();
}

void KCMKuick::load()
{
    TDEConfig config( "konquerorrc");
    config.setGroup("kuick-copy");
    dialog->m_sbCopy->setValue(config.readNumEntry("ShowRecent",5) );

    config.setGroup("kuick-move" );
    dialog->m_sbMove->setValue(config.readNumEntry("ShowRecent",5) );
    
    TDEConfig cfg("kuick_plugin.desktop", true, false, "services");
    cfg.setDesktopGroup();
    bool hidden=cfg.readBoolEntry("Hidden", false);
    dialog->m_chkShow->setChecked(!hidden);
    slotShowToggled();
    
    emit changed(false);
}

KCMKuick::~KCMKuick()
{
}

void KCMKuick::load(const TQString & /*s*/)
{
}

void KCMKuick::configChanged()
{
    emit changed(true);
}

void KCMKuick::save()
{
    TDEConfig config("konquerorrc" );
    config.setGroup("kuick-copy");

    config.writeEntry("ShowRecent", dialog->m_sbCopy->value() );

    config.setGroup("kuick-move" );
    config.writeEntry("ShowRecent", dialog->m_sbMove->value() );

    config.sync();		//is it necessary ?

    if ( dialog->m_chkShow->isChecked() ) {       
       TQString servicespath = TDEGlobal::dirs()->saveLocation( "services");
       TQFile::remove(servicespath+"/kuick_plugin.desktop");
    }
    else {
       TDEConfig cfg("kuick_plugin.desktop", false, false, "services");
       cfg.setDesktopGroup();
       cfg.writeEntry("Hidden", true);
    }
    KService::rebuildKSycoca(this);
    
    emit changed(false);
}

void KCMKuick::slotClearCopyCache( ) {
    TDEConfig config("konquerorrc");
    config.setGroup("kuick-copy" );
    config.writePathEntry("Paths", TQStringList() );
    config.sync();		//is it necessary ?
}

void KCMKuick::slotClearMoveCache() {
    TDEConfig config("konquerorrc");
    config.setGroup("kuick-move" );
    config.writePathEntry("Paths", TQStringList() );
    config.sync();		//is it necessary ?
}

void KCMKuick::defaults()
{
    dialog->m_sbCopy->setValue(4);
    dialog->m_sbMove->setValue(4);
    
    dialog->m_chkShow->setChecked(true);
    slotShowToggled();
    
    emit changed( true );
}

TQString KCMKuick::quickHelp() const
{
    return i18n("<h1>Kuick</h1> With this module you can configure Kuick, the TDE quick"
		"copy and move plugin for Konqueror.");
}

#include "kcmkuick.moc"
