/***************************************************************************
                         textilinetem.h  -  description
                             -------------------
    begin                : Do Sep 2 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#ifndef TEXTLINEITEM_H
#define TEXTLINEITEM_H
#include <tqstring.h>
#include "documentitem.h"

/**
 * Class TextLineItem
 * plain text (drawn using TQSimpleRichText) on screen or printer.
 */
class TextLineItem : public DocumentItem {
public:
    TextLineItem ();
        
    void  draw (TQPainter* painter);
    void drawZpl( TQTextStream* stream );
    void drawIpl( TQTextStream* stream, IPLUtils* utils );
    void drawEPcl( TQTextStream* stream );
    int  rtti () const { return eRtti_TextLine; }

    void  loadXML (TQDomElement* element);
    void  saveXML (TQDomElement* element);
    
    void  setText (const TQString & text);
    void  setFont (int index);
    int   getFont () const; 
    void setMagHor (int count);
    int getMagHor () const;
    int getMagVert () const;
    void setMagVert (int count);
    TQString  text () const;
    
private:
    void init();
    
private:
    TQString m_text;
    int m_font;
    int m_rotate;
    int m_mag_vert;
    int m_mag_hor;
};
#endif //TEXTITEM_H

