/*
 * This file is part of the KDE project
 *
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeinstance.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kdebug.h>
#include <kgenericfactory.h>

#include <kis_doc.h>
#include <kis_global.h>
#include <kis_types.h>
#include <kis_view.h>

#include "historydocker.h"

typedef KGenericFactory<ChalkHistoryDocker> ChalkHistoryDockerFactory;
K_EXPORT_COMPONENT_FACTORY( chalkhistorydocker, ChalkHistoryDockerFactory( "chalk" ) )

ChalkHistoryDocker::ChalkHistoryDocker(TQObject *parent, const char *name, const TQStringList &)
        : KParts::Plugin(parent, name)
{
    


    if ( parent->inherits("KisView") )
    {
        setInstance(ChalkHistoryDockerFactory::instance());
        // Create history docker
        // Add the docker to the docker manager
        // Connect the undo system to the docker
    }

}

ChalkHistoryDocker::~ChalkHistoryDocker()
{
}
