/***************************************************************************
                          addlinkdialog.cpp  -  Trinity Desktop Planetarium
                             -------------------
    begin                : Sun Oct 21 2001
    copyright            : (C) 2001 by Jason Harris
    email                : kstars@30doradus.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeapplication.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <tqbuttongroup.h>
#include <tqlayout.h>

#include "addlinkdialog.h"
#include "skyobject.h"

AddLinkDialog::AddLinkDialog( TQWidget *parent, const TQString &oname )
	: KDialogBase( KDialogBase::Plain, i18n( "Add Custom URL to %1" ).arg( oname ), Ok|Cancel, Ok, parent ), ObjectName( oname ) {

	TQFrame *page = plainPage();
	setMainWidget(page);

	vlay = new TQVBoxLayout( page, 0, spacingHint() );
	ald = new AddLinkDialogUI(page);

	vlay->addWidget( ald );
	vlay->activate();

	//connect signals to slots
	connect( ald->URLButton, TQ_SIGNAL( clicked() ), this, TQ_SLOT( checkURL() ) );
	connect( ald->TypeBox, TQ_SIGNAL( clicked( int ) ), this, TQ_SLOT( changeDefaultDescription( int ) ) );

	ald->ImageRadio->setChecked(true);
	ald->DescBox->setText( i18n( "Show image of " ) + ObjectName );
}

void AddLinkDialog::checkURL( void ) {
	KURL _url ( url() );
	if ( _url.isValid() ) {   //Is the string a valid URL?
		kapp->invokeBrowser( _url.url() );   //If so, launch the browser to see if it's the correct document
	} else {   //If not, print a warning message box that offers to open the browser to a search engine.
		TQString message = i18n( "The URL is not valid. Would you like to open a browser window\nto the Google search engine?" );
		TQString caption = i18n( "Invalid URL" );
		if ( KMessageBox::warningYesNo( 0, message, caption, i18n("Browse Google"), i18n("Do Not Browse") )==KMessageBox::Yes ) {
			kapp->invokeBrowser( "http://www.google.com" );
		}
	}
}

void AddLinkDialog::changeDefaultDescription( int id ) {
//If the user hasn't changed the default desc text, but the link type (image/webpage)
//has been toggled, update the default desc text
	if ( id==1 && desc().startsWith( i18n( "Show image of " ) ) ) {
		ald->DescBox->setText( i18n( "Show webpage about " ) + ObjectName );
	}

	if ( id==0 && desc().startsWith( i18n( "Show webpage about " ) ) ) {
		ald->DescBox->setText( i18n( "Show image of " ) + ObjectName );
	}
}

#include "addlinkdialog.moc"
