#include "tdemid_part.h"

#include <kinstance.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include <tdeaction.h>
#include <tqiconset.h>

#include <tdeparts/partmanager.h>

#include "tdemidclient.h"
#include <tqtimer.h>
#include <tdelibs_export.h>

K_EXPORT_COMPONENT_FACTORY( libtdemidpart, KMidFactory )

/**
 * We need one static instance of the factory for our C 'main'
 * function
 */
TDEInstance *KMidFactory::s_instance = 0L;

KMidFactory::KMidFactory()
{
  s_instance=0L;
}

KMidFactory::~KMidFactory()
{
  if (s_instance)
  {
    delete s_instance->aboutData();
    delete s_instance;
  }

  s_instance = 0;
}

KParts::Part *KMidFactory::createPartObject(TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name, const char*,
    const TQStringList& )
{
  KParts::Part *obj = new KMidPart(parentWidget, widgetName, parent, name);
  return obj;
}

TDEAboutData *KMidFactory::aboutData()
{
    TDEAboutData *aboutdata = new TDEAboutData("tdemid", "TDEMid", "2.0",
        I18N_NOOP("MIDI/Karaoke file player"), TDEAboutData::License_GPL,
        I18N_NOOP("(c) 1997,98,99,2000, Antonio Larrosa Jimenez"),"",
        "http://perso.wanadoo.es/antlarr/tdemid.html");
    aboutdata->addAuthor("Antonio Larrosa Jimenez",
        I18N_NOOP("Original Developer/Maintainer"),"larrosa@kde.org",
        "http://perso.wanadoo.es/antlarr/index.html");
    return aboutdata;
}

TDEInstance *KMidFactory::instance()
{
  if ( !s_instance )
    s_instance = new TDEInstance( aboutData() );

  return s_instance;
}

  KMidPart::KMidPart(TQWidget *parentWidget, const char *widgetName,
                     TQObject *parent, const char *name)
: KParts::ReadOnlyPart(parent, name)
{
  setInstance(KMidFactory::instance());

  widget = new tdemidClient(parentWidget, actionCollection());
  widget->show();
  widget->setFocusPolicy(TQWidget::ClickFocus);
  setWidget(widget);

  // create and connect our actions
   (void)new TDEAction(i18n("Play"), "media-playback-start", 0, this,
      TQ_SLOT(slotPlay()), actionCollection(),
      "play");

   (void)new TDEAction(i18n("Stop"), "media-playback-stop", 0, this,
      TQ_SLOT(slotStop()), actionCollection(),
      "stop");

   (void)new TDEAction(i18n("Backward"),
      "2leftarrow", 0, this,
      TQ_SLOT(slotBackward()), actionCollection(),
      "backward");

   (void)new TDEAction(i18n("Forward"),
        "2rightarrow", 0, this,
      TQ_SLOT(slotForward()), actionCollection(),
      "forward");

  m_extension = new KMidBrowserExtension(this);

  setXMLFile("tdemid_partui.rc");


}

KMidPart::~KMidPart()
{
}

bool KMidPart::openFile()
{
  widget->openURL(m_file);
  widget->stop();
  widget->show();
  TQTimer::singleShot(2000, this, TQ_SLOT(slotPlay()));

  return true;
}

bool KMidPart::closeURL()
{
  slotStop();
  return true;
}

void KMidPart::slotPlay()
{
  widget->stop();
  widget->play();
}


void KMidPart::slotStop()
{
  widget->stop();
}
KMidBrowserExtension::KMidBrowserExtension(KMidPart *parent)
    : KParts::BrowserExtension(parent, "KMidBrowserExtension")
{
}

KMidBrowserExtension::~KMidBrowserExtension()
{
}
#include "tdemid_part.moc"
