/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/

#include "kmfipteditorpart.h"


// TQt includes
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqmultilineedit.h>


// KDE includes
#include <kinstance.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdeaccel.h>
#include <tdefiledialog.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>

// Project includes
#include "kmfruleedit.h"
#include "../core/kmyfirewallinterface.h"
#include "../kmfwidgets/kmfmainwindow.h"
#include "../kmfwidgets/kmfiptdocoptions.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"
namespace KMF {
KMFIPTEditorPart::KMFIPTEditorPart( TQWidget *parentWidget, const char *widgetName,
                                  TQObject *parent, const char *name )
	: KParts::ReadWritePart( parent, name ) {
	KMFMainWindow *app = 0;
	// we need an instance
	setInstance( KMFIPTEditorPartFactory::instance() );
	
	
	app = dynamic_cast<KMFMainWindow*>( parent );
	if ( ! app ) {
		KMessageBox::error(0,"Oops wrong parent class found for kmfinstallerplugin!!!");
	}
	
	// this should be your custom internal widget
	m_ruleedit = new KMFRuleEdit( parentWidget, widgetName );
	m_ruleedit->setKMFMainWindow( app );
	m_ruleedit->setFocusPolicy( TQWidget::ClickFocus );
	
	m_editdoc = new KMFIPTDocOptions( parentWidget , "m_editdoc" );
	m_editdoc->hide();
	
	m_ruleedit->loadDoc( app->network() );
	m_editdoc->loadDoc( app->network()->currentDocAsIPTDoc() );
	
	connect( app, TQ_SIGNAL( sigUpdateView() ),
		m_ruleedit, TQ_SLOT( slotUpdateView() ) );

	connect( app, TQ_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_ruleedit, TQ_SIGNAL( sigUpdateView( NetfilterObject* ) ) );

	connect( app, TQ_SIGNAL( sigEnableActions( bool ) ),
		this, TQ_SLOT( slotEnableActions( bool ) ) );

	connect ( m_editdoc, TQ_SIGNAL( sigConfigChanged() ),
	          m_ruleedit, TQ_SLOT( slotUpdateView() ) );

	// notify the part that this is our internal widget
	setWidget( m_ruleedit );
	
	m_actionEditChain = new TDEAction( i18n( "&Edit Chain" ), TQIconSet( BarIcon( "configure_toolbars", KMFIPTEditorPartFactory::instance() ) ),
	                                 0 , this, TQ_SLOT( slotEditChain() ), actionCollection(), "edit_chain" );

	m_actionNewChain = new TDEAction( i18n( "Add New Chain..." ), TQIconSet( BarIcon( "view_tree", KMFIPTEditorPartFactory::instance() ) ),
	                                0 , this, TQ_SLOT( slotNewChain() ), actionCollection(), "new_chain" );

	m_actionDelChain = new TDEAction( i18n( "Delete Chain" ), TQIconSet( BarIcon( "edit-delete", KMFIPTEditorPartFactory::instance() ) ),
	                                0 , this, TQ_SLOT( slotDelChain() ), actionCollection(), "del_chain" );

	
	m_actionNewRule = new TDEAction( i18n( "Add New Rule..." ), TQIconSet( TDEGlobal:: iconLoader()->loadIcon( "rule", TDEIcon::Toolbar ) ) ,
								   TDEStdAccel::shortcut(TDEStdAccel::New) , this, TQ_SLOT( slotNewRule() ), actionCollection(), "new_rule" );
	
//	m_actionNewRule->setIconSet( TQIconSet(  loader->loadIcon( "rule-22", TDEIcon::User ) ) );							   
								   
	m_actionDelRule = new TDEAction( i18n( "Delete Rule" ), TQIconSet( BarIcon( "edit-delete", KMFIPTEditorPartFactory::instance() ) ),
								   TDEStdAccel::shortcut(TDEStdAccel::DeleteWordBack), this, TQ_SLOT( slotDelRule() ), actionCollection(), "del_rule" );
	
	m_actionEditDocOptions = new TDEAction( i18n( "&Configure Firewall Options..." ), "configure", 0 , this, TQ_SLOT( slotEditDocOptions() ),
	                                    actionCollection(), "edit_doc_options" );

	
	m_actionEditNetwork = new TDEAction( i18n( "&Configure the Network" ), TQIconSet( BarIcon( "configure_toolbars", KMFIPTEditorPartFactory::instance() ) ), 0 , this, TQ_SLOT( slotEditNetwork() ),
	                                    actionCollection(), "edit_network" );

	
	// set our XML-UI resource file
	setXMLFile( "kmfipteditorpartui.rc" );

	// we are read-write by default
	setReadWrite( true );

	// we are not modified since we haven't done anything yet
	setModified( false );
}

KMFIPTEditorPart::~KMFIPTEditorPart() {}

void KMFIPTEditorPart::setReadWrite( bool rw ) {
	// notify your internal widget of the read-write state

	ReadWritePart::setReadWrite( rw );
}

void KMFIPTEditorPart::slotEditDocOptions() {
	KMFMainWindow* app = dynamic_cast<KMFMainWindow*>( parent() );
	if ( ! app ) {
		KMessageBox::error(0,"Oops wrong parent class found for KMFIPTEditorPart!!!");
		return;
	}
	m_editdoc->loadDoc( app->network()->currentDocAsIPTDoc() );
	m_editdoc ->show();
}


void KMFIPTEditorPart::slotEditChain() {
	m_ruleedit->slotEditChain();
}

void KMFIPTEditorPart::slotNewChain() {
	m_ruleedit->slotAddChain();
}

void KMFIPTEditorPart::slotDelChain() {
	m_ruleedit->slotDelChain();
}

void KMFIPTEditorPart::slotNewRule() {
	m_ruleedit->slotAddRule();
}

void KMFIPTEditorPart::slotDelRule() {
	m_ruleedit->slotDelRule();
}

void KMFIPTEditorPart::slotEditNetwork() {
	kdDebug() << "KMFIPTEditorPart::slotEditNetwork()" << endl;
	m_ruleedit->slotEditNetwork();
}


//###########################################
void KMFIPTEditorPart::setModified( bool modified ) {
	// get a handle on our Save action and make sure it is valid
	TDEAction * save = actionCollection() ->action( KStdAction::stdName( KStdAction::Save ) );
	if ( !save )
		return ;

	// if so, we either enable or disable it based on the current
	// state
	if ( modified )
		save->setEnabled( true );
	else
		save->setEnabled( false );

	// in any event, we want our parent to do it's thing
	ReadWritePart::setModified( modified );
}

bool KMFIPTEditorPart::openFile() {
	// m_file is always local so we can use TQFile on it
	//     TQFile file(m_file);
	//     if (file.open(IO_ReadOnly) == false)
	//         return false;
	//
	//     // our example widget is text-based, so we use TQTextStream instead
	//     // of a raw TQDataStream
	//     TQTextStream stream(&file);
	//     TQString str;
	//     while (!stream.eof())
	//         str += stream.readLine() + "\n";
	//
	//     file.close();
	//
	//     // now that we have the entire file, display it
	// //     m_widget->setText(str);
	//
	//     // just for fun, set the status bar
	//     emit setStatusBarText( m_url.prettyURL() );

	return true;
}

bool KMFIPTEditorPart::saveFile() {
	// if we aren't read-write, return immediately
	/*    if (isReadWrite() == false)
	        return false;
	 
	    // m_file is always local, so we use TQFile
	    TQFile file(m_file);
	    if (file.open(IO_WriteOnly) == false)
	        return false;
	 
	    // use TQTextStream to dump the text to the file
	    TQTextStream stream(&file);
	    stream << m_widget->text();
	 
	    file.close();
	*/ 
	return true;
}

void KMFIPTEditorPart::fileOpen() {
	// this slot is called whenever the File->Open menu is selected,
	// the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
	// button is clicked
	/*    TQString file_name = KFileDialog::getOpenFileName();
	 
	    if (file_name.isEmpty() == false)
	        openURL(file_name);*/
}

void KMFIPTEditorPart::fileSaveAs() {
	// this slot is called whenever the File->Save As menu is selected,
	/*    TQString file_name = KFileDialog::getSaveFileName();
	    if (file_name.isEmpty() == false)
	        saveAs(file_name);*/
}

void KMFIPTEditorPart::slotEnableActions( bool on ) {
	if ( on ) {
		m_actionEditChain->setEnabled( true );
		m_actionNewChain->setEnabled( true );
		m_actionNewRule->setEnabled( true );
		m_actionDelChain->setEnabled( true );
		m_actionDelRule->setEnabled( true );
		m_actionEditDocOptions->setEnabled( true );
	} else {
		m_actionEditChain->setEnabled( false );
		m_actionNewChain->setEnabled( false );
		m_actionNewRule->setEnabled( false );
		m_actionDelChain->setEnabled( false );
		m_actionDelRule->setEnabled( false );
		m_actionEditDocOptions->setEnabled( false );

	}
}


// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data

TDEInstance* KMFIPTEditorPartFactory::s_instance = 0L;
TDEAboutData* KMFIPTEditorPartFactory::s_about = 0L;

KMFIPTEditorPartFactory::KMFIPTEditorPartFactory()
		: KParts::Factory() {}

KMFIPTEditorPartFactory::~KMFIPTEditorPartFactory() {
	delete s_instance;
	delete s_about;

	s_instance = 0L;
}

KParts::Part* KMFIPTEditorPartFactory::createPartObject( TQWidget *parentWidget, const char *widgetName,
        TQObject *parent, const char *name,
        const char *classname, const TQStringList& ) {
	// Create an instance of our Part
	KMFIPTEditorPart * obj = new KMFIPTEditorPart( parentWidget, widgetName, parent, name );

	// See if we are to be read-write or not
	if ( TQCString( classname ) == "KParts::ReadOnlyPart" )
		obj->setReadWrite( false );

	return obj;
}

TDEInstance* KMFIPTEditorPartFactory::instance() {
	if ( !s_instance ) {
		s_about = new TDEAboutData( "kmfipteditorpart", I18N_NOOP( "kmfipteditorpartPart" ), "0.1" );
		s_about->addAuthor( "Christian Hubinger", 0, "chubinger@irrsinnig.org" );
		s_instance = new TDEInstance( s_about );
	}
	return s_instance;
}

extern "C" {
	TDE_EXPORT void* init_libkmfipteditorpart() {
		return new KMFIPTEditorPartFactory;
	}
}

}

#include "kmfipteditorpart.moc"
