#include <tdeglobal.h>
#include <tqfileinfo.h>
#include <tqregexp.h>
#include <kstandarddirs.h>
#include <tqdir.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <tdeio/job.h>
#include <kurl.h>
#include <tdeio/netaccess.h>
#include <kzip.h>

#include "waSkinManager.h"
#include "waSkinModel.h"

WaSkinManager::WaSkinManager() : DCOPObject("WaSkinManager") {
}

WaSkinManager::~WaSkinManager() {
}

TQStringList WaSkinManager::availableSkins() {
	TQStringList skinDirs = TDEGlobal::dirs()->findDirs("data", "noatun/skins/winamp");
	TQStringList skin_list;
	
	// This loop adds them all to our skin list
	for(unsigned int x = 0;x < skinDirs.count();x++) {
		TQDir skinTQDir(skinDirs[x]);

		// We only want directories, although there shouldn't be anything else
		skinTQDir.setFilter( TQDir::Dirs );
		// I guess name is as good as any
		skinTQDir.setSorting( TQDir::Name );

		for (unsigned int y = 0;y < skinTQDir.count();y++) {
			TQStringList skins = skinTQDir.entryList(TQDir::Dirs, TQDir::Name);

			// We really don't care for '.' and '..'
			if (skinTQDir[y][0] != (char)'.') {
				// Add ourselves to the list, using our directory name
				skin_list += skinTQDir[y];
 			}
		}
	}

	return skin_list;
}

TQString WaSkinManager::currentSkin() {
	return mCurrentSkin;
}

TQString WaSkinManager::defaultSkin() {
	return "Winamp";
}

bool WaSkinManager::loadSkin(TQString skinName) {
	TQStringList skins = TDEGlobal::dirs()->findDirs("data", "noatun/skins/winamp/" + skinName);

	if (!skins.count())
		mCurrentSkin = defaultSkin();
	else
		mCurrentSkin = skinName;

	return _waskinmodel_instance->load(skins[0]);
}

bool WaSkinManager::installSkin(TQString _url) {
	TQString location = TDEGlobal::dirs()->saveLocation("data", "noatun/skins/winamp");
	KURL url(_url);
	TQString mimetype = KMimeType::findByURL(_url)->name();

	if (mimetype == "inode/directory")
	{
		TDEIO::Job *job = TDEIO::copy(url, location, !url.isLocalFile());
		connect(job, TQ_SIGNAL(result(TDEIO::Job *)), this, TQ_SIGNAL(updateSkinList()));
		return true;
	}
	else if ((mimetype == "interface/x-winamp-skin") || (mimetype == "application/x-zip"))
	{
		if (!url.isLocalFile())
			return false;

		TQString base_path;
		base_path = location + "/" + TQFileInfo(url.path()).baseName().replace(TQRegExp("_"), " ");
		TDEIO::Job *job = TDEIO::copy("zip:" + url.path(), base_path);
		connect(job, TQ_SIGNAL(result(TDEIO::Job *)), this, TQ_SIGNAL(updateSkinList()));

		return true;
	}

	return false;
}

bool WaSkinManager::removeSkin(TQString skinName) {
	if (!skinRemovable(skinName))
		return false;

	TQStringList skins = TDEGlobal::dirs()->findDirs("data", "noatun/skins/winamp/" + skinName);

	TDEIO::Job *job = TDEIO::del(KURL(skins[0]), false, false);
	connect(job, TQ_SIGNAL(result(TDEIO::Job *)), this, TQ_SIGNAL(updateSkinList()));

	return true;
}

bool WaSkinManager::skinRemovable(TQString skinName) {
	TQStringList skins = TDEGlobal::dirs()->findDirs("data", "noatun/skins/winamp/" + skinName);

	if (!skins.count())
		return false;

	TQFileInfo info(skins[0]);
	return info.isWritable();
}

TQStringList WaSkinManager::skinMimeTypes() {
	TQStringList temp;

	temp.append("interface/x-winamp-skin");
	temp.append("application/x-zip");
	temp.append("inode/directory");

	return temp;
}

#include "waSkinManager.moc"
