	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "retrievedlg.h"
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <kbuttonbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tdeapplication.h>
#include <kseparator.h>
#include <tdelocale.h>
#include <kstdguiitem.h>
#include <stdio.h>
#include <set>
#include <arts/debug.h>
#include <tqpushbutton.h>

static void min_size(TQWidget *w) {
  w->setMinimumSize(w->sizeHint());
}

RetrieveDlg::RetrieveDlg(TQWidget *parent) :TQDialog(parent,"X", TRUE)
{
	setCaption(i18n("Retrieve Structure From Server"));

	TQVBoxLayout *mainlayout = new TQVBoxLayout(this);

// caption label: "Synthesis running..."

	mainlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(TQString(" ")+i18n("Published structures")+TQString(" "));
	captionlabel->setAlignment(AlignCenter);
	min_size(captionlabel);
	mainlayout->addWidget(captionlabel);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler2);
	mainlayout->addSpacing(5);

// listwidget

	listbox = new TQListBox(this);
    listbox->setMinimumSize(300,200);

	arts_debug("TODO:PORT:get available structures");
#if 0
	// sort the result:
	vector<StructureDesc> *structures = Synthesizer->publishedStructures();
	set<string> names;

	unsigned long i;
	for(i=0;i<structures->length();i++)
		names.insert(structures[i]->Name());

	set<string>::iterator ni;
	for(ni=names.begin();ni!=names.end();++ni)
		listbox->insertItem((*ni).c_str());
#endif

	mainlayout->addWidget(listbox);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler);
	mainlayout->addSpacing(5);

// buttons

	TQHBoxLayout *buttonlayout = new TQHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), this, TQ_SLOT( help() ));
	bbox->addStretch(1);

	TQButton *cancelbutton = bbox->addButton(KStdGuiItem::cancel());
	connect( cancelbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(reject() ) );

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(accept() ) );

	bbox->layout();

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->freeze();
}

TQString RetrieveDlg::result()
{
	if(listbox->currentItem() != -1)
	{
		return(listbox->text(listbox->currentItem()));
	}
	return TQString();
}

void RetrieveDlg::help()
{
	TDEApplication::kApplication()->invokeHelp("", "karts");
}
#include "retrievedlg.moc"
