/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPEFILTER_H
#define RECIPEFILTER_H

#include <tqobject.h>

class TDEListView;
class TQListViewItem;

class RecipeFilter : public TQObject
{
	TQ_OBJECT

public:
	RecipeFilter( TDEListView * );

public slots:
	void filter( const TQString & );
	void filterCategory( int categoryID );

private:
	bool isParentOf( TQListViewItem *parent, TQListViewItem *to_check );
	bool hideIfEmpty( TQListViewItem *parent = 0 );

	TDEListView *listview;
	TQListViewItem *currentCategory;
};

#endif //RECIPEFILTER_H
