#ifndef _KVI_MDICHILD_H_
#define _KVI_MDICHILD_H_
//=================================================================================================
//
//   File : kvi_mdichild.h
//   Creation date : Wed Jun 21 2000 17:35:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=================================================================================================

#include "kvi_settings.h"
#include "kvi_string.h"

#include <tqframe.h>
#include <tqtoolbutton.h>
#include <tqlabel.h>


class KviMdiManager;
class KviMdiChild;
class KviMdiCaption;

class TQCursor;



class KVIRC_API KviMdiChild : public TQFrame
{
	friend class KviMdiManager;
	friend class KviMdiCaption;
	TQ_OBJECT
  
public:
	KviMdiChild(KviMdiManager* par,const char * name = 0);
	~KviMdiChild();
public:
	enum MdiChildState { Maximized , Minimized , Normal };
protected:
	KviMdiManager              * m_pManager;
	KviMdiCaption              * m_pCaption;
private:
	int                          m_iResizeCorner;
	int                          m_iLastCursorCorner;
	bool                         m_bResizeMode;
	TQWidget                    * m_pClient;
	MdiChildState                m_state;
	TQRect                        m_restoredGeometry;

	TQString                      m_szXmlActiveCaption;
	TQString                      m_szXmlInactiveCaption;
	TQString                      m_szPlainCaption;
public:
	TQRect restoredGeometry();
	void setRestoredGeometry(const TQRect &r){ m_restoredGeometry = r; };
	void setClient(TQWidget * w);
	TQWidget * client(){ return m_pClient; };
	void unsetClient();
	KviMdiCaption * captionLabel(){ return m_pCaption; };
	MdiChildState state(){ return m_state; };
	const TQString & plainCaption(){ return m_szPlainCaption; };
	const TQString & xmlActiveCaption(){ return m_szXmlActiveCaption; };
	const TQString & xmlInactiveCaption(){ return m_szXmlInactiveCaption; };
	void setCaption(const TQString & plain,const TQString & xmlActive,const TQString & xmlInactive);
	virtual TQSize sizeHint();
	void setIcon(const TQPixmap &pix);
	const TQPixmap * icon();
	void enableClose(bool bEnable);
	bool closeEnabled();
	KviMdiManager * manager(){ return m_pManager; };
	void activate(bool bSetFocus);
	void reloadImages();
public slots:
	void maximize();
	void minimize();
	void restore();
	void systemPopupSlot();
	void closeRequest();
signals:
	void systemPopupRequest(const TQPoint & pnt);
protected:
	virtual void setBackgroundMode(TQWidget::BackgroundMode bgmd);
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void mouseMoveEvent(TQMouseEvent *e);
	virtual void mouseReleaseEvent(TQMouseEvent *e);
	virtual void leaveEvent(TQEvent *e);
	virtual void focusInEvent(TQFocusEvent *);
	virtual void moveEvent(TQMoveEvent *e);
//	bool eventFilter(TQObject *o,TQEvent *e);
	void emitSystemPopupRequest(const TQPoint & pnt){ emit systemPopupRequest(pnt); };
private:
//	void linkChildren(TQWidget *w);
//	void unlinkChildren(TQWidget *w);
	TQCursor getResizeCursor(int resizeCorner);
	void resizeWindowOpaque(int resizeCorner);
	int getResizeCorner(int ax,int ay);
	void calculateMinimumSize(int &minWidth,int &minHeight);
	void setResizeCursor(int resizeCorner);
	void calculateResizeRect(int resizeCorner,TQPoint mousePos,TQRect &resizeRect,int minWidth,int minHeight);
};


#endif //_KVI_MDICHILD_H_
