//=============================================================================
//
//   File : kvi_colorwin.cpp
//   Creation date : Wed Jan 6 1999 04:30:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_colorwin.h"
#include "kvi_app.h"
#include "kvi_options.h"


#include <tqnamespace.h>
#include <tqpainter.h>
#include <tqstring.h>
#include <tqevent.h>


KviColorWindow::KviColorWindow()
:TQWidget(0,"toplevel_color_window",TQt::WType_Popup)
{
	setFocusPolicy(TQWidget::NoFocus);
	setBackgroundMode(TQt::NoBackground);
	setFixedSize(146,38);
	m_pOwner = 0;
	TQFont fnt = TQFont();
	fnt.setStyleHint(TQFont::TypeWriter);
	fnt.setPointSize(10);
	//TQFont fnt("fixed",10);
	setFont(fnt);
	m_iTimerId = -1;
}

KviColorWindow::~KviColorWindow()
{
	if(m_iTimerId != -1)
		killTimer(m_iTimerId);
//	if(m_pOwner)m_pOwner->setFocus();
}

void KviColorWindow::popup(TQWidget *owner)
{
	m_pOwner = owner;
	show();
}


void KviColorWindow::paintEvent(TQPaintEvent *)
{
	static int clrIdx[16]={ 1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1 };
	TQPainter p(this);

	for(int i=0;i<16;i++)
	{
		p.fillRect((i % 8) * 18,(i / 8) * 18,18,18,KVI_OPTION_MIRCCOLOR(i));
		p.setPen(KVI_OPTION_MIRCCOLOR(clrIdx[i]));
		KviStr szI(KviStr::Format,"%d",i);
		p.drawText((i % 8) * 18,(i / 8) * 18,18,18,TQt::AlignVCenter | TQt::AlignHCenter,szI.ptr());
	}
}

void KviColorWindow::keyPressEvent(TQKeyEvent *e)
{
	if(m_iTimerId != -1)
		killTimer(m_iTimerId);
	hide();
	if(m_pOwner)g_pApp->sendEvent(m_pOwner,e);
}

void KviColorWindow::mousePressEvent(TQMouseEvent *e)
{
	TQString str;
	int key=e->x()/18;
	if (e->x()<36 && e->y()>18) key +=8;
	if (e->x()>36 && e->y()>18) key -=2;
	int ascii=key+48;
	str.setNum(key);
	if (e->x()>36 && e->y()>18) 
		if(m_pOwner) g_pApp->sendEvent(m_pOwner,new TQKeyEvent(TQEvent::KeyPress,TQt::Key_1,49,TQt::NoButton,"1"));
	if(m_pOwner) g_pApp->sendEvent(m_pOwner,new TQKeyEvent(TQEvent::KeyPress,key,ascii,TQt::NoButton,str));
	if(m_iTimerId != -1)
		killTimer(m_iTimerId);
	hide();
}
void KviColorWindow::show()
{
	m_iTimerId = startTimer(10000); //10 sec ...seems enough
	TQWidget::show();
}

void KviColorWindow::timerEvent(TQTimerEvent *)
{
	if(m_iTimerId != -1)
		killTimer(m_iTimerId);
	hide();
}


#include "kvi_colorwin.moc"
