/****************************************************************************
**
** Copyright (C) 2012 Timothy Pearson.  All rights reserved.
**
** This file is part of the TDE Qt4 style interface
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef SIMPLESTYLE_H
#define SIMPLESTYLE_H

#include <QtGui/QWindowsStyle>
#include <QFileDialog>
#include <tqintcache.h>

#include "tdeqt4converter.h"

QT_BEGIN_NAMESPACE
class QPalette;
QT_END_NAMESPACE

class TQWidget;
class TQTabBar;
class TQRadioButton;
class TQCheckBox;
class TQProgressBar;
class TQPopupMenu;
class TQComboBox;
class TQSlider;
class TQScrollBar;
class TQSpinBox;
class TQSpinWidget;
class TQTitleBar;
class TQMenuBar;
class TQToolBox;
class TQToolButton;

class TDEAboutData;
class TDEApplication;
class TQPixmapCache;

typedef TQIntCache<TQWidget> TQWidgetCache;

class Qt4TDEStyle : public QWindowsStyle
{
    Q_OBJECT

public:
    Qt4TDEStyle();
    ~Qt4TDEStyle();

    void polish(QPalette &palette);
    void polish(QWidget *widget);
    void unpolish(QWidget *widget);
    bool eventFilter(QObject *obj, QEvent *ev);

    void drawPrimitive(PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w = 0) const;
    void drawControl(ControlElement element, const QStyleOption * option, QPainter * painter, const QWidget * widget = 0) const;
    void drawComplexControl(ComplexControl control, const QStyleOptionComplex * option, QPainter * painter, const QWidget * widget = 0) const;
    QRect subElementRect(SubElement element, const QStyleOption * option, const QWidget * widget = 0) const;
    QRect subControlRect(ComplexControl control, const QStyleOptionComplex * option, SubControl subControl, const QWidget * widget = 0) const;

    int pixelMetric(PixelMetric metric, const QStyleOption * option = 0, const QWidget * widget = 0) const;
    int styleHint(StyleHint hint, const QStyleOption * option = 0, const QWidget * widget = 0, QStyleHintReturn * returnData = 0) const;
    QSize sizeFromContents(ContentsType type, const QStyleOption * option, const QSize & contentsSize, const QWidget * widget = 0) const;

public slots:
    QIcon standardIconImplementation(StandardPixmap standardIcon, const QStyleOption * option = 0, const QWidget * widget = 0) const;

private slots:
    void handleQt4ObjectDestroyed(QObject*);

private:
    TQWidget* initializeInterfaceWidget(TQt3WidgetType wt, const QWidget * widget, const QStyleOption* qt4styleoptions = 0, bool forceReload = false) const;

    TQWidget* m_tqt3parent_widget;
    TQWidget* m_tqt3generic_widget;
    TQWidget* m_tqt3window_widget;

    int m_tqt3IconSize_NoGroup;
    int m_tqt3IconSize_Desktop;
    int m_tqt3IconSize_FirstGroup;
    int m_tqt3IconSize_Toolbar;
    int m_tqt3IconSize_Tabbar;
    int m_tqt3IconSize_MainToolbar;
    int m_tqt3IconSize_Small;
    int m_tqt3IconSize_Panel;
    int m_tqt3IconSize_LastGroup;
    int m_tqt3IconSize_User;
    int m_tqt3IconSize_MenuItem;
    int m_tqt3IconSize_Large;
    int m_tqt3IconSize_Listview;
    int m_tqt3IconSize_Button;
    int m_tqt3DialogButtons_ShowIcons;

    mutable const QWidget* m_previousQt4InterfaceWidget;
    mutable TQWidget* m_previousTQt3InterfaceWidget;

    TDEAboutData* m_aboutData;
    TQApplication* m_tqApplication;
    TDEApplication* m_tdeApplication;
    TQString m_qt4ApplicationName;

    TQPixmapCache* m_internalTQt3PixmapCache;
    TQWidgetCache* m_internalTQt3WidgetCache;

    int hoverTab;
};

#endif
