###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
    tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


#### check for headers

if( WITH_NATIVE_GNU_BARCODE )
    check_include_file( "barcode.h" HAVE_NATIVE_GNU_BARCODE )
    if( HAVE_NATIVE_GNU_BARCODE )
        set( _ENABLE_NATIVE_GNU_BARCODE 1 )
      else()
        tde_message_fatal( "Barcode is requested, but GNU Barcode header was not found on your system" )
    endif()
endif( WITH_NATIVE_GNU_BARCODE )

if( WITH_JAVASCRIPT )
    tde_save( CMAKE_REQUIRED_INCLUDES )
    list( APPEND CMAKE_REQUIRED_INCLUDES ${TQT_INCLUDE_DIRS} ${TDE_INCLUDE_DIR} )
    check_include_file_cxx( "kjs/interpreter.h" HAVE_JAVASCRIPT )
    if( HAVE_JAVASCRIPT )
        set( USE_JAVASCRIPT 1 )
        set( NO_KJS_EMBED 1 )
      else()
        tde_message_fatal( "Javascript interpreter is requested, but tdelibs Javascript header (kjs) was not found on your system" )
    endif( HAVE_JAVASCRIPT )
    tde_restore( CMAKE_REQUIRED_INCLUDES )
  else()
    set( USE_JAVASCRIPT false )
endif( WITH_JAVASCRIPT )

#### check for pcre2

pkg_check_modules( PCRE2 libpcre2-8 libpcre2-posix )
if( NOT PCRE2_FOUND )
   tde_message_fatal( "pcre2 is required but was not found on your system." )
endif( )
