/*
 * Copyright (c) 2002-2003 Nicolas HADACEK (hadacek@kde.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef DATA_H
#define DATA_H

#include <math.h>

#include <tqdom.h>
#include <tqvaluevector.h>

#include <KoPageLayout.h>

#include "misc.h"

class KoFilterChain;


namespace PDFImport
{
class Options;

class Data
{
public:
    Data(KoFilterChain *, const DRect &pageRect, KoPageLayout,
         const Options &);

    TQDomElement createElement(const TQString &name)
        { return _document.createElement(name); }
    void createParagraph(const TQString &text, ParagraphType type,
                         const TQValueVector<TQDomElement> &layouts,
                         const TQValueVector<TQDomElement> &formats);

    KoFilterChain *chain() const { return _chain; }
    const Options &options() const { return _options; }
    TQDomDocument document() const { return _document; }
    const DRect &pageRect() const { return _pageRect; }
    uint imageIndex() const { return _imageIndex; }
    uint textIndex() const { return _textIndex; }
    TQDomElement bookmarks() const { return _bookmarks; }
    TQDomElement pictures() const { return _pictures; }

    TQDomElement pictureFrameset(const DRect &);

    void initPage(const TQValueVector<DRect> &,
                  const TQValueList<TQDomElement> &pictures);
    void endDump();

public:
    uint pageIndex;

private:
    enum FramesetType { Text, Picture };
    TQDomElement createFrameset(FramesetType, const TQString &name);
    TQDomElement createFrame(FramesetType, const DRect &,
                            bool forceMainFrameset);

private:
    KoFilterChain *_chain;
    TQDomDocument   _document;
    uint           _imageIndex, _textIndex;
    TQDomElement    _mainElement, _framesets, _pictures, _bookmarks, _paper;
    TQValueVector<TQDomElement> _textFramesets;
    DRect          _pageRect, _marginRect;
    const Options &_options;
};

} // namespace

#endif
