/* Copyright (C) 2003
	 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	 Boston, MA 02110-1301, USA.
	 */

#ifndef __SUBVERSION_WIDGET_H__
#define __SUBVERSION_WIDGET_H__

#include <tqlistview.h>
#include "svn_blamewidget.h"
#include "svn_logviewwidget.h"
#include <tqvaluelist.h>

class subversionPart;
#include <ktabwidget.h>
#include <tdeio/defaultprogress.h>
#include <tqguardedptr.h>
class KTextEdit;
class SvnLogHolder;
class SvnBlameHolder;
class SvnLogViewWidget;
class TQToolButton;
class TQPushButton;

/** The main Subversion DockWidget. Contains logview-output, blame-output, status and etc */
// class subversionWidget : public SvnOutputWidgetBase
class subversionWidget : public KTabWidget
{
    TQ_OBJECT
  
public:
    subversionWidget(subversionPart *part, TQWidget *parent, const char* name);
    ~subversionWidget();

    // append what?. Append any text status outputs
    void append( TQString notifications );
    void showLogResult( TQValueList<SvnLogHolder> *holderList, TQString reqUrl );
    void showBlameResult( TQValueList<SvnBlameHolder> *blamelist );

protected slots:
    void closeCurrentTab();

private:
    KTabWidget* tab(){ return this; }
	subversionPart *m_part;
    
    TQGuardedPtr<KTextEdit> m_edit;
    TQPushButton *m_closeButton;

};
/**
 * reimplement compare(), to be able to sort any item by integer
 */
class SvnIntSortListItem : public TQListViewItem {
public:
	SvnIntSortListItem ( TQListView* parent=0 );
	~SvnIntSortListItem ();
	/** Returns < 0 if this item is less than i, 0 if they are equal and > 0 if this item is greater than i. 
	 */
	virtual int compare( TQListViewItem* i, int col, bool ascending ) const;
};

class SvnLogViewItem : public SvnIntSortListItem {
    public:
        SvnLogViewItem( TQListView* parent );
        ~SvnLogViewItem();

        TQString m_pathList;
        TQString m_message;
};

/////////////////////////////////////////////////////////////
/// Subversion Progress Display Widget
class SvnProgressDlg : public TDEIO::DefaultProgress {
public:
	SvnProgressDlg( bool showNow = true );
	~SvnProgressDlg();
	void setSourceUrl( const TQString & );
	void setDestUrl( const TQString & );
};

#endif
