import org.trinitydesktop.qt.*;

public class Tut5 extends TQVBox {
	public Tut5() {
		TQPushButton quit = new TQPushButton("Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, TQ_SIGNAL("clicked()"), tqApp(), TQ_SLOT("quit()"));

		TQLCDNumber lcd = new TQLCDNumber(2, this, "lcd");

		TQSlider slider = new TQSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);

		connect(slider, TQ_SIGNAL("valueChanged(int)"), lcd, TQ_SLOT("display(int)"));
	}
	
	public static void main(String[] args) {
		TQApplication a = new TQApplication(args);

		Tut5 w = new Tut5();
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.trinitydesktop.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
