/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <tqapplication.h>
#include <tqfile.h>
#include <tqregexp.h>
#include <tqstring.h>
#include <tqspinbox.h>

#include <tdelocale.h>
#include <klineedit.h>
#include <tdemessagebox.h>
#include <tdeio/netaccess.h>
#include <kurl.h>

#include "settings.h"
#include "fileimporterbibtex.h"
#include "webquerybibsonomy.h"

namespace KBibTeX
{
    WebQueryBibSonomyWidget::WebQueryBibSonomyWidget( TQWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();

        Settings *settings = Settings::self();
        TQString value = settings->getWebQueryDefault( "BibSonomy" );
        value = value == TQString::null ? "" : value;
        lineEditQuery->setText( value );
        slotTextChanged( value, true );
    }


    WebQueryBibSonomy::WebQueryBibSonomy( TQWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryBibSonomyWidget( parent );
    }

    WebQueryBibSonomy::~WebQueryBibSonomy()
    {
        delete m_widget;
    }

    TQString WebQueryBibSonomy::title()
    {
        return i18n( "BibSonomy" );
    }

    TQString WebQueryBibSonomy::disclaimer()
    {
        return i18n( "BibSonomy bookmark sharing system" );
    }

    TQString WebQueryBibSonomy::disclaimerURL()
    {
        return "http://www.bibsonomy.org/help/about/";
    }

    WebQueryWidget *WebQueryBibSonomy::widget()
    {
        return m_widget;
    }

    void WebQueryBibSonomy::query()
    {
        WebQuery::query();
        Settings *settings = Settings::self();
        settings->setWebQueryDefault( "BibSonomy", m_widget->lineEditQuery->text() );

        setNumStages( 1 );

        TQString searchTerm = m_widget->lineEditQuery->text().stripWhiteSpace().replace( '$', "" );
        if ( searchTerm.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        int numberOfResults = m_widget->spinBoxMaxHits->value();

        KURL url = KURL( TQString( "http://www.bibsonomy.org/bib/search/%2?items=%1" ).arg( numberOfResults ) .arg( searchTerm.replace( "%", "%25" ).replace( "+", "%2B" ).replace( " ", "%20" ).replace( "#", "%23" ).replace( "&", "%26" ).replace( "?", "%3F" ) ) );

        BibTeX::File *bibFile = downloadBibTeXFile( url );
        if ( bibFile != NULL && !m_aborted )
        {
            for ( BibTeX::File::ElementList::iterator it = bibFile->begin(); it != bibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    emit foundEntry( entry, false );
            }
            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            TQString message = TDEIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( TQString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            setEndSearch( WebQuery::statusAborted );

        if ( bibFile != NULL )
            delete bibFile;
    }
}
#include "webquerybibsonomy.moc"
