# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools flag-o-matic virtualx

DESCRIPTION="The Persistence of Vision Raytracer"
HOMEPAGE="https://www.povray.org/"
SRC_URI="https://github.com/POV-Ray/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="AGPL-3"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm64 ~x86"
IUSE="debug +io-restrictions tiff X"

DEPEND="
	dev-libs/boost:=
	media-libs/libjpeg-turbo:=
	media-libs/libpng:=
	sys-libs/zlib
	tiff? ( media-libs/tiff:= )
	X? ( media-libs/libsdl )"
RDEPEND="${DEPEND}"
DEPEND="${DEPEND}
	dev-build/autoconf-archive"

src_prepare() {
	pushd unix &>/dev/null || die
	bash -x prebuild.sh || die
	popd &>/dev/null || die

	rm -rf libraries || die

	eautoreconf
	eapply_user
}

src_configure() {
	# Fixes bug 71255
	if [[ $(get-flag march) == k6-2 ]]; then
		filter-flags -fomit-frame-pointer
	fi

	# The config files are installed correctly (e.g. povray.conf),
	# but the code compiles using incorrect [default] paths
	# (based on /usr/local...), so povray will not find the system
	# config files without the following fix:
	append-cppflags -DPOVLIBDIR=\\\""${EPREFIX}"/usr/share/${PN}\\\" -DPOVCONFDIR=\\\""${EPREFIX}"/etc/${PN}\\\"

	# TODO: Restore OpenEXR if upstream start to support OpenEXR 3/imath
	econf \
		COMPILED_BY="Portage (Gentoo $(uname)) on $(hostname -f)" \
		$(use_enable debug) \
		$(use_enable io-restrictions) \
		--without-openexr \
		$(use_with tiff libtiff "${EPREFIX}/usr/$(get_libdir)") \
		$(use_with X libsdl "${EPREFIX}/usr/$(get_libdir)") \
		$(use_with X x "${EPREFIX}/usr/$(get_libdir)") \
		$(usex tiff "" "NON_REDISTRIBUTABLE_BUILD=yes") \
		--with-boost-libdir="${EPREFIX}/usr/$(get_libdir)" \
		--without-libmkl \
		--disable-pipe \
		--disable-static \
		--disable-strip \
		--disable-optimiz \
		--disable-optimiz-arch
}

src_test() {
	virtx default
}

pkg_preinst() {
	# Copy the old config files if they are in the old location
	# but do not yet exist in the new location.
	# This way, they can be treated by CONFIG_PROTECT as normal.
	local conf_file version_dir
	for conf_file in "${ED}"/etc/"${PN}"/*; do
		if [ ! -e "${EROOT}/etc/${PN}/${conf_file}" ]; then
			for version_dir in $(echo "${EROOT}"/etc/"${PN}"/* | grep "^[0-9]" | sort -rn); do
				if [ -e "${EROOT}/etc/${PN}/${version_dir}/${conf_file}" ]; then
					mv "${EROOT}/etc/${PN}/${version_dir}/${conf_file}" "${EROOT}/etc/${PN}" || die
					elog "Note: ${conf_file} moved from ${EROOT}/etc/povray/${version_dir}/ to ${EROOT}/etc/povray/"
					break
				fi
			done
		fi
	done
}
