# Provides support for TDE and TQt based ports.
#
# MAINTAINER:	slavek.banko@axis.cz
# TDE port map:	trinity.port.mk > Mk/bsd.trinity.mk

.if !defined(_INCLUDE_TRINITY_MK)
_INCLUDE_TRINITY_MK=yes


### General information

TDE_VERSION?=	14.1.3
TDE_PREFIX=	/opt/trinity
PREFIX=		${TDE_PREFIX}

HOMEPAGE=		https://www.trinitydesktop.org/
MAINTAINER?=		slavek.banko@axis.cz
MASTER_SITE_TDE?=	http://mirror.ppa.trinitydesktop.org/trinity/deb/trinity-r14.1.x/pool/main/%SUBDIR%/ \
			http://mirror.ppa.trinitydesktop.org/trinity/deb/trinity-sb/pool/main-r14/%SUBDIR%/
MASTER_SITE_TDE_DEPS?=	http://mirror.ppa.trinitydesktop.org/trinity/deb/trinity-r14.1.x/pool/deps/%SUBDIR%/ \
			http://mirror.ppa.trinitydesktop.org/trinity/deb/trinity-sb/pool/deps-r14/%SUBDIR%/
MASTER_SITES=		${MASTER_SITE_TDE}

PORTVERSION=	${TDE_VERSION}${TDE_PREVERSION:C/~(pre|r|s)([0-9]*).*/.p\2/1}
DISTNAME=	${PORTNAME}_${TDE_VERSION}${TDE_PREVERSION:C/(~(pre|r|s)[0-9]*).*/\1/1}
DISTSRC=	${PORTNAME}-${TDE_VERSION}${TDE_PREVERSION}
EXTRACT_CMD=	gtar
EXTRACT_SUFX=	.orig.tar.xz
.if ${MASTER_SITES:M*nightly-builds*}
EXTRACT_BASE=	# tarballs from nightly-builds not contains directory by name of package
.else
EXTRACT_BASE=	${DISTSRC:C/~(pre|r|s)([0-9]*[^\/]*)/~pre\2/1}/
.endif
EXTRACT_AFTER_ARGS+=--transform "s|^\(${DISTSRC:C/~(pre|r|s)([0-9]*[^\/]*)/~pre\2/1}[^/]*\)\?|${DISTNAME}/|S" --wildcards


### General build options

TDE_DEBUG?=	0

.MAKEFLAGS=	# Reset makeflags to avoid -B supplied from bsd.port.subdir.mk

PKG_CONFIG_PATH=${TDE_PREFIX}/libdata/pkgconfig:/usr/local/libdata/pkgconfig:/usr/libdata/pkgconfig

EXTRACT_DEPENDS=\
		gtar:archivers/gtar \

BUILD_DEPENDS=\
		automake:devel/automake \
		libtool:devel/libtool \
		gettext:devel/gettext \
		gfind:misc/findutils \
		gsed:textproc/gsed \
		bash:shells/bash \

USES+=	ninja

PATCH_STRIP=	-p1

TDE_BUILD_SUBDIR=.build	# Set to empty for build-in-source

# Build Flags
TDE_FLAGS=-I${LOCALBASE}/include
TDE_LDFLAGS=-L${LOCALBASE}/lib

.if ${TDE_DEBUG}
TDE_FLAGS+= -g
CMAKE_BUILD_TYPE=Debug
.else
TDE_FLAGS+= -DNDEBUG
CMAKE_BUILD_TYPE=RelWithDebInfo
.endif
CMAKE_BUILD_TYPE_U=`echo ${CMAKE_BUILD_TYPE} | tr [:lower:] [:upper:]`

# Custom configure commands
TDE_BUILD_ENV=\
	TDEDIR="${TDE_PREFIX}" \
	PATH="${TDE_PREFIX}/bin:${PATH}" \
	PKG_CONFIG_PATH="${PKG_CONFIG_PATH}" \
	CFLAGS="${CFLAGS} ${TDE_FLAGS}" \
	CXXFLAGS="${CXXFLAGS} ${TDE_FLAGS}" \
	LDFLAGS="${LDFLAGS} ${TDE_LDFLAGS}"

TDE_CMAKE_CONFIGURE=\
	export ${TDE_BUILD_ENV}; \
	export CMAKE_PREFIX_PATH="${LOCALBASE}"; \
	[ -z "${TDE_BUILD_SUBDIR}" ] || mkdir ${WRKSRC}/${TDE_BUILD_SUBDIR} && \
	cd ${WRKSRC}/${TDE_BUILD_SUBDIR} && \
	cmake ${WRKSRC} \
		-GNinja \
		-DCMAKE_BUILD_TYPE="${CMAKE_BUILD_TYPE}" \
		-DCMAKE_C_FLAGS="${TDE_FLAGS}" \
		-DCMAKE_CXX_FLAGS="${TDE_FLAGS}" \
		-DCMAKE_EXE_LINKER_FLAGS_${CMAKE_BUILD_TYPE_U}="${TDE_LDFLAGS}" \
		-DCMAKE_MODULE_LINKER_FLAGS_${CMAKE_BUILD_TYPE_U}="${TDE_LDFLAGS}" \
		-DCMAKE_SHARED_LINKER_FLAGS_${CMAKE_BUILD_TYPE_U}="${TDE_LDFLAGS}" \
		\
		-DCMAKE_INSTALL_PREFIX="${TDE_PREFIX}" \
		-DCMAKE_INSTALL_RPATH="${TDE_PREFIX}/lib" \
		-DCMAKE_SKIP_RPATH=OFF \
		-DCMAKE_VERBOSE_MAKEFILE=ON \


TDE_AUTOTOOLS_CONFIGURE=\
	export ${TDE_BUILD_ENV}; \
	[ -z "${TDE_BUILD_SUBDIR}" ] || mkdir ${WRKSRC}/${TDE_BUILD_SUBDIR} && \
	cd ${WRKSRC}/${TDE_BUILD_SUBDIR} && \
	${WRKSRC}/configure \
		--prefix=${TDE_PREFIX} \
		--exec-prefix=${TDE_PREFIX} \
		--bindir=${TDE_PREFIX}/bin \
		--libdir=${TDE_PREFIX}/lib \
		--includedir=${TDE_PREFIX}/include \
		--datadir=${TDE_PREFIX}/share \
		\
		--enable-shared \
		--disable-static \
		--disable-dependency-tracking \
		--enable-final \
		--enable-new-ldflags \
		--enable-closure \
		--enable-rpath \

.if ${TDE_DEBUG}
TDE_AUTOTOOLS_CONFIGURE+=--enable-debug
.else
TDE_AUTOTOOLS_CONFIGURE+=--disable-debug
.endif

### Custom build targets
tde-pathfix:
	cd ${WRKSRC}; \
	[ -d admin ] && [ -e admin/am_edit ] && \
	gsed -i admin/am_edit \
	        admin/debianrules \
	        admin/nmcheck \
	     -e "s|/usr/bin/perl|${LOCALBASE}/bin/perl|"; \
	[ -d cmake ] && \
	gsed -i cmake/install_apidox \
	        cmake/generate_apidox \
	     -e "s|/bin/bash|${LOCALBASE}/bin/bash|g"; \
	gfind -name "*.pl" | xargs -r \
	gsed -i -e "s|/usr/bin/perl|${LOCALBASE}/bin/perl|"

tde-build:
	${TDE_BUILD_ENV} \
	${MAKE_CMD} -C "${WRKSRC}/${TDE_BUILD_SUBDIR}"

tde-check:
	${TDE_BUILD_ENV} \
	${MAKE_CMD} -C "${WRKSRC}/${TDE_BUILD_SUBDIR}" check

tde-install:
	${TDE_BUILD_ENV} \
	DESTDIR=${STAGEDIR} \
	${MAKE_CMD} -C "${WRKSRC}/${TDE_BUILD_SUBDIR}" install

### Custom build targets for CMAKE
tde-cmake-prepare:
	[ -z "${TDE_BUILD_SUBDIR}" ] || rm -rf "${WRKSRC}/${TDE_BUILD_SUBDIR}"

tde-cmake-build: tde-build

tde-cmake-check: tde-check

tde-cmake-install: tde-install

### Custom build targets for AUTOTOOLS
tde-autotools-prepare:
	[ -z "${TDE_BUILD_SUBDIR}" ] || rm -rf "${WRKSRC}/${TDE_BUILD_SUBDIR}"
	cp -f "${LOCALBASE}/share/aclocal/libtool.m4" "${WRKSRC}/admin/libtool.m4.in"
	cp -f "${LOCALBASE}/share/libtool/build-aux/ltmain.sh" "${WRKSRC}/admin/ltmain.sh"
	gsed -i "${WRKSRC}/admin/acinclude.m4.in" -e "s|/usr/include/tqt|${LOCALBASE}/include/tqt|g"
	${MAKE_CMD} -C "${WRKSRC}" -f "admin/Makefile.common"

tde-autotools-build: tde-build

tde-autotools-check: tde-check

tde-autotools-install: tde-install

.endif
