
from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQTimer, TQ_SIGNAL, TQFont, TQString
from tdecore import i18n
from tdeui import KPushButton, KEdFind, KTextEdit

iconName = 'find'
labelText = 'KEdFind'
docParts = ('tdeui', 'KEdFind')
helpText = ("An example of the KEdFind dialog.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Edit Find Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, TQ_SIGNAL('clicked()'), self.showEdFind)


    def showEdFind(self):
        dlg = self.dlg = KEdFind(self)
        self.connect(dlg, TQ_SIGNAL('done()'),
                    self.doneClicked)
        self.connect(dlg, TQ_SIGNAL('search()'),
                    self.searchClicked)        
        dlg.exec_loop()


    def doneClicked(self):
        print('done searching')

    def searchClicked(self):
        print('searching: ', self.dlg.getText(), end=' ')
        if self.dlg.get_direction():
            print('(backwards) ', end=' ')
        else:
            print('(forwards) ', end=' ')
        if self.dlg.case_sensitive():
            print('(case-sensitive)')
        else:
            print('(case-insensitive)')
        

        

