/***************************************************************************
                          tagdialog.cpp  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavsky <pdima@mail.univ.kiev.ua>
                           (C) 2002-2004 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include qt headers
#include <tqdir.h>
#include <tqfileinfo.h>
#include <tqevent.h>

// include kde headers
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <tdetexteditor/viewcursorinterface.h>
#include <tdeconfig.h>
#include <kurl.h>
#include <kstdguiitem.h>
#include <kdebug.h>

#include "tagattr.h"
#include "tagdialog.h"
#include "tagwidget.h"
#include "tagimgdlg.h"
#include "tagxml.h"

#include "document.h"
#include "qextfileinfo.h"
#include "quantacommon.h"
#include "resource.h"
#include "qtag.h"
#include "kafkacommon.h"

TagDialog::TagDialog(TQTag* dtdTag, Tag *tag, KURL a_baseURL)
    : TQTabDialog( 0L, "tagdialog", true)
{
  init(dtdTag, a_baseURL);

  m_tag = tag;
  if (m_tag)
  {
    for (int i = 0; i < m_tag->attrCount(); i++)
    {
    dict->insert(m_tag->attribute(i), new TQString(m_tag->attributeValue(i)));
    }
  }
  mainDlg = 0L;
  parseTag();

}

TagDialog::TagDialog(TQTag* dtdTag, Tag *tag, const TQString& selection, KURL a_baseURL)
    : TQTabDialog( 0L, "tagdialog", true), m_selection(selection)
{
    init(dtdTag, a_baseURL);

    m_tag = tag;
    if (m_tag)
    {
        for (int i = 0; i < m_tag->attrCount(); i++)
        {
            dict->insert(m_tag->attribute(i), new TQString(m_tag->attributeValue(i)));
        }
    }
    mainDlg = 0L;
    parseTag();
}

TagDialog::TagDialog(TQTag* dtdTag, TQString attrs, KURL a_baseURL)
    : TQTabDialog( 0L, "tagdialog", true)
{
  init(dtdTag, a_baseURL);
  if ( !attrs.isNull() )
  {
    parseAttributes(attrs);
  }
  mainDlg = 0L;
  m_tag = 0L;
  parseTag();
}

TagDialog::TagDialog(TQTag* dtdTag, const TQString& selection, TQString attrs, KURL a_baseURL)
    : TQTabDialog( 0L, "tagdialog", true), m_selection(selection)
{
    init(dtdTag, a_baseURL);
    if ( !attrs.isNull() )
    {
        parseAttributes(attrs);
    }
    mainDlg = 0L;
    m_tag = 0L;
    parseTag();
}

TagDialog::~TagDialog()
{
  if (deleteTag)
  {
    delete dtdTag;
  }
  delete dict;
}


void TagDialog::init(TQTag *a_dtdTag, KURL a_baseURL)
{
  setOkButton(KStdGuiItem::ok().text());
  setCancelButton(KStdGuiItem::cancel().text());

  connect( this, TQ_SIGNAL(applyButtonPressed()),  TQ_SLOT(slotAccept()) );
  connect( this, TQ_SIGNAL(cancelButtonPressed()), TQ_SLOT(reject()) );

  if (!a_dtdTag)   //the tag is invalid, let's create a default one
  {
    dtdTag = new TQTag();
    dtdTag->setName(i18n("Unknown tag"));
    deleteTag = true;
  } else
  {
    dtdTag = a_dtdTag;
    deleteTag = false;
  }
  dict = new TQDict<TQString>(1,false);
  dict->setAutoDelete(true);
  m_baseURL = a_baseURL;

  TQString caption = i18n("Tag Properties: ");
  caption += dtdTag->name();
  setCaption( caption);
  resize(420,400);
}
/**  */
void TagDialog::parseTag()
{
  if (dtdTag->name() != i18n("Unknown tag")) //read from the extra tags
  {
    TQDomDocument doc;
    if (dtdTag->name().lower() == "img") //NOTE: HTML specific code!
    {
       mainDlg = new TagImgDlg(dtdTag->parentDTD, this);
      ((TagImgDlg *)mainDlg)->writeAttributes( dict );
    }
    //read the tag file it is available
    else if (TQFileInfo(dtdTag->fileName()).exists())
    {
       TQFile f( dtdTag->fileName() );
       f.open( IO_ReadOnly );
       if ( doc.setContent( &f ) )
       {
       TQString tagName = dtdTag->name();
       TQDomNodeList nodeList = doc.elementsByTagName("tag");
       for ( uint i = 0; i < nodeList.count(); i++)
       {
          TQDomNode n = nodeList.item(i);
          TQString nodeTagName = n.toElement().attribute("name");
          if (!dtdTag->parentDTD->caseSensitive)
              nodeTagName = nodeTagName.upper();
          if (nodeTagName == tagName && n.toElement().elementsByTagName("attr").count() > 0) //read a tag
          {
            mainDlg = new Tagxml( n, dtdTag, m_selection, this );
            ((Tagxml    *)mainDlg)->writeAttributes( dict );
            break;
          }
       }
       }
       f.close();
    }
    else
    {
      TQString docString = "<!DOCTYPE TAGS>\n<TAGS>\n";
      docString += TQString("<tag name=\"%1\">\n").arg(dtdTag->name());
      docString += QuantaCommon::xmlFromAttributes(dtdTag->attributes());
      docString += "</tag>\n</TAGS>\n";
      doc.setContent(docString);
      TQDomNode domNode2 = doc.firstChild().firstChild();
      mainDlg = new Tagxml( domNode2, dtdTag, m_selection, this );
    }

  if ( mainDlg )
  {
    addTab( mainDlg, i18n("Main") );
  }

  TDEConfig *dtdConfig = new TDEConfig(dtdTag->parentDTD->fileName);
  dtdConfig->setGroup("General");
  int numOfPages = dtdConfig->readNumEntry("NumOfPages");
  extraPageList = new TQPtrList<Tagxml>();
  extraPageList->setAutoDelete(true);
  for (int i = 1; i <= numOfPages; i++)
  {
    Tagxml *extraPage = 0L;
    dtdConfig->setGroup(TQString("Page%1").arg(i));
    TQString title = dtdConfig->readEntry("Title");
    TQStringList groupList;
    groupList = dtdConfig->readListEntry("Groups");
    TQDomDocument extraDoc; //build an internal tag XML for the groups
    bool addPage = false;
    TQString docString = "<!DOCTYPE TAGS>\n<TAGS>\n";
    docString += TQString("<tag name=\"Page%1\">\n").arg(i);
    for (uint j = 0; j < groupList.count(); j++)
    {
       groupList[j] = groupList[j].stripWhiteSpace();
    }
    TQDomDocument commonDoc;
    TQString commonFileName = TQFileInfo(dtdTag->fileName()).dirPath() + "/common.tag";
    if (TQFile(commonFileName).exists())
    {
      TQFile commonFile(commonFileName);
      commonFile.open(IO_ReadOnly);
      if (doc.setContent(&commonFile))
      {
        int row = 0;
        TQDomNodeList nodeList = doc.elementsByTagName("tag");
        for ( uint j = 0; j < nodeList.count(); j++)
        {
          TQDomNode node = nodeList.item(j);
          TQString nodeTagName = node.toElement().attribute("name");
          if (groupList.contains(nodeTagName) && dtdTag->commonGroups.contains(nodeTagName)) //add the attributes of this common tag to a new tab
          {
            TQString s;
            TQTextStream str(&s, IO_ReadWrite);
            TQString s2;
            TQTextStream str2(&s2, IO_ReadWrite);
            for ( TQDomNode n = node.firstChild(); !n.isNull(); n = n.nextSibling() )
            {
              if (n.nodeName() == "attr")
              {
                TQDomElement el = n.toElement();
                str.reset();
                str << "<attr name=\"" << el.attribute("name") << "\" type=\"" << el.attribute("type", "input");
                str << "\" source=\"" << el.attribute("source");
                str << "\" interface=\"" << el.attribute("interface");
                str << "\" method=\"" << el.attribute("method");
                str << "\" arguments=\"" << el.attribute("arguments");
                str << "\">" << endl;
                str << "    <text>" << el.attribute("name") << "</text>" << endl;
                str << "    <textlocation col=\"0\" row=\"" << row << "\" />" << endl;
                str << "    <location col=\"1\" row=\"" << row << "\" />" << endl;
                TQDomNodeList childNodes = n.childNodes();
                for ( uint k = 0; k < childNodes.count(); k++)
                {
                  TQDomNode childNode = childNodes.item(j);
                  childNode.save(str2, 2);
                  str << s2;
                }
                str << "</attr>" << endl;
                row++;
              }

            }
            docString += s;
            addPage = true;
          }
        }
        commonFile.close();
      }
    }

    docString += "</tag>\n</TAGS>\n";
    if (addPage)
    {
      extraDoc.setContent(docString);
      TQDomNode domNode = extraDoc.firstChild().firstChild();
      extraPage = new Tagxml( domNode, dtdTag, m_selection, this );
      extraPage->writeAttributes( dict );
      addTab( extraPage, i18n(title.utf8()) );
      extraPageList->append(extraPage);
    }
//    delete attrs;
  }
 }
}

/** Insert an attribute to dict*/
void TagDialog::insertAttribute(TQString *attr, TQString *value)
{
  dict->insert( *attr , value );
}

/** Return the attributes in TQDict<TQString> format*/
TQDict<TQString> * TagDialog::getAttributes()
{
  return dict;
}


/** Return all the attributes in one string*/
TQString TagDialog::getAttributeString()
{
  TQDictIterator<TQString> it( *dict );

  TQString attrStr;

  while ( it.current() ) {
    TQString attr  = QuantaCommon::attrCase(it.currentKey());
    TQString val   = *it.current();

    TQString attrval = " ";  // attr=value

    if ( val.isEmpty()) {
      attrval += attr; // for checkboxes dont print =""
    }
    else {
        attrval += attr + "=" + qConfig.attrValueQuotation + val + qConfig.attrValueQuotation;
    }
    attrStr = attrval + attrStr;

    ++it;
  }
  return attrStr;
}

/**Return the value of the attribute specified by attr. */
TQString TagDialog::getAttribute(const TQString& attr)
{
 TQString attrStr = getAttributeString()+" ";
 int pos = attrStr.upper().find(attr.upper());
 if (pos != -1)
 {
   pos = attrStr.find("=",pos+1) + 1;
   return attrStr.mid(pos, attrStr.find(" ",pos) - pos);
 }
 else
 {
  return TQString();
 }

}

/**  */
void TagDialog::slotAccept()
{

  if (dtdTag->name() != i18n("Unknown tag"))
  {
    if ( mainDlg )
       ((Tagxml *)mainDlg)->readAttributes( dict );
    for (uint i = 0; i < extraPageList->count(); i++)
    {
      extraPageList->at(i)->readAttributes( dict );
    }
    delete extraPageList;
  }
  accept();
}

/** return document path */
KURL TagDialog::baseURL()
{
 return m_baseURL;
}


void TagDialog::parseAttributes(const TQString &attrs)
{
  TQString t = attrs;

  t = t.stripWhiteSpace();

  while ( !t.isEmpty() )
  {
    int i = 0;
    while ( !t[i].isSpace() && !t[i].isNull() && t[i] != '=' )  i++;

    TQString attr = t.left(i);
    TQString *value = new TQString();

    t = t.remove(0,i).stripWhiteSpace();

   if ( t[0] == '=' ) {
      t = t.remove(0,1).stripWhiteSpace();

      if ( t[0] == '"' ) {
        i = 1;
        while ( t[i] != '"' && !t[i].isNull() ) i++;
        if ( t[i] == '"' )
          *value = t.mid(1,i-1);
        else
          *value = t.mid(1,i);
        t = t.remove(0,i+1).stripWhiteSpace();
      }
      else
      if ( t[0] == '\'' ) {
        i = 1;
        while ( t[i] != '\'' && !t[i].isNull() ) i++;
        if ( t[i] == '\'' )
          *value = t.mid(1,i-1);
        else
          *value = t.mid(1,i);
        t = t.remove(0,i+1).stripWhiteSpace();
      }
      else {

        i=0;
        while ( !t[i].isSpace() && !t[i].isNull() )  i++;

        *value = t.left(i);
        t = t.remove(0,i).stripWhiteSpace();
      }

      // debug ( name+" , "+attr[attrcount]+"="+value[attrcount]+";" );




   }
   // tqDebug("attr :%s; value :%s;",attr.data(),value->data() );
   dict->insert( attr , value );
 }

}

/** Insert the new tag into the Document*/
void TagDialog::insertTag(Document *w, bool insertInLine)
{
  if (dtdTag->name() != i18n("Unknown tag"))
  {
    TQString newTag = getAttributeString();
    newTag = TQString("<")+QuantaCommon::tagCase(dtdTag->name())+newTag;

    if ( dtdTag->parentDTD->singleTagStyle == "xml" &&
          (dtdTag->isSingle() || (!qConfig.closeOptionalTags && dtdTag->isOptional()))
        )
    {
      newTag.append(" /");
    }
    newTag.append(">");

    TQString secondPartOfTag = TQString("</")+QuantaCommon::tagCase(dtdTag->name())+">";

    if ( !insertInLine )
    {
      TQString space="";
      space.fill( ' ',w->viewCursorIf->cursorColumnReal() );
      newTag += "\n" + space + "  ";
      secondPartOfTag = "\n" + space + secondPartOfTag;
    }

    if ( (!qConfig.closeTags && !dtdTag->isSingle()) ||
          (dtdTag->isSingle()) ||
          (!qConfig.closeOptionalTags && dtdTag->isOptional()) )
    {
      secondPartOfTag = "";
    }

    w->insertTag( newTag, secondPartOfTag);
  }
}

Node *TagDialog::buildNode(Document *w)
{
	Node *node;
	TQString attrStr("");
	TQDictIterator<TQString> it( *dict );


	node = kafkaCommon::createNode(dtdTag->name(), "", Tag::XmlTag, w);

	while (it.current())
	{
		node->tag->editAttribute(QuantaCommon::attrCase(it.currentKey()), *it.current());
		++it;
	}

	return node;
}

void TagDialog::showEvent(TQShowEvent *ev)
{
  TQTabDialog::showEvent(ev);
  if (dynamic_cast<Tagxml*>(mainDlg))
     static_cast<Tagxml*>(mainDlg)->focusToFirstItem();
}

#include "tagdialog.moc"
