/* The TdeGtk Theming Engine for Gtk+.
 * Copyright (C) 2011 Canonical Ltd
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authored by Andrea Cimitan <andrea.cimitan@canonical.com>
 *
 */

#include <gtk/gtk.h>

#include "tdegtk-engine.h"
#include "tdegtk-support.h"
#include "tdegtk-types.h"

gboolean
tdegtk_gdk_rgba_is_default (GdkRGBA *color)
{
  GdkRGBA default_color;

  /* pink is default GdkRGBA color set in gtk/gtkstyleproperty.c */
  gdk_rgba_parse (&default_color, "pink");

  return gdk_rgba_equal (&default_color, color);
}

void
tdegtk_get_line_width (GtkThemingEngine *engine,
                      gdouble          *line_width)
{
  GtkBorder border;
  GtkStateFlags state;

  state = gtk_theming_engine_get_state (engine);

  gtk_theming_engine_get_border (engine, state, &border);

  *line_width = MIN (MIN (border.top, border.bottom),
                     MIN (border.left, border.right));
}

gboolean
tdegtk_gtk_border_is_zero (GtkBorder *border)
{
  return (border->top == 0) && (border->bottom == 0) && (border->left == 0) && (border->right == 0);
}

void
tdegtk_lookup_functions (TdeGtkEngine          *engine,
                        TdeGtkStyleFunctions **functions)
{
  /* only one style is defined now,
   * add here a check for a theming engine css property,
   * for example -tdegtk-style, and assign new styles */
  if (functions)
    *functions = &engine->style_functions[TDEGTK_STYLE_DEFAULT];
}

void
tdegtk_trim_scale_allocation (GtkThemingEngine *engine,
                             gdouble          *x,
                             gdouble          *y,
                             gdouble          *width,
                             gdouble          *height)
{
	/* Do nothing! */
}
