/* This file is part of the KDE project
  Copyright (C) 2003-2004 Alexander Dymo <cloudtemple@mksat.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef KUDESIGNER_DOC_H
#define KUDESIGNER_DOC_H

#include <KoDocument.h>
#include <kcommand.h>
#include <KoCommandHistory.h>
#include "plugin.h"

class TQCanvas;
class TQDomNode;
class TQIODevice;
class TQDomDocument;

namespace Kudesigner
{
class Canvas;
}

class KudesignerDoc: public KoDocument
{
    TQ_OBJECT
  
public:
    KudesignerDoc( TQWidget *parentWidget = 0, const char *widgetName = 0, TQObject* parent = 0, const char* name = 0, bool singleViewMode = false );

    ~KudesignerDoc();

    virtual void paintContent( TQPainter& painter, const TQRect& rect, bool transparent = FALSE, double zoomX = 1.0, double zoomY = 1.0 );

    virtual bool initDoc( InitDocFlags flags, TQWidget* parentWidget );

    virtual bool loadOasis( const TQDomDocument&, KoOasisStyles&, const TQDomDocument&, KoStore* );
    virtual bool saveOasis( KoStore*, KoXmlWriter* );

    virtual bool loadXML( TQIODevice *, const TQDomDocument & );
    virtual TQDomDocument saveXML();

    virtual int supportedSpecialFormats() const;
    virtual bool saveToStream( TQIODevice * dev );

    Kudesigner::Canvas *canvas();

    void loadPlugin( const TQString& name );
    KuDesignerPlugin *plugin();
    Dock propertyPosition();
    void setForcedPropertyEditorPosition( Dock );

    void addCommand( KCommand *cmd );

    virtual bool modified() const;

signals:
    void canvasChanged( Kudesigner::Canvas * );
    void modificationMade( bool );

public slots:
    virtual void setModified( const bool val );
    virtual void setModified();
    virtual void initEmpty();

protected:
    virtual KoView* createViewInstance( TQWidget* parent, const char* name );
    virtual bool completeSaving( KoStore* store );
    virtual bool completeLoading( KoStore* store );

protected slots:
    void commandExecuted();
    void documentRestored();

private:
    KoCommandHistory *history;

    Kudesigner::Canvas *docCanvas;

    KuDesignerPlugin *m_plugin;
    Dock m_propPos;
    bool m_modified;
};

#endif
