/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3u-20000719-0930 (Alpha 3)
 * 
 * Portions Copyright (c) 1995-2000
 * The University of Utah, The Regents of the University of California, and
 * The University of Chicago.  Permission is hereby granted to use, modify, 
 * and distribute this file in any manner provided this notice remains intact.
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* Implementation : PYTHON */
#include <config.h>

#ifdef HAVE_PYTHON

#define SWIGPYTHON
/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

/* Type information structure */

typedef struct _swig_type_info {
  char  *name;                 
  void *(*converter)(void *);
  struct _swig_type_info  *next;
  struct _swig_type_info  *prev;
} _swig_type_info;

/* Constant information structure */
typedef struct _swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    _swig_type_info **ptype;
} _swig_const_info;

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(_swig_type_info *) SWIG_TypeRegister(_swig_type_info *);
SWIGEXPORT(_swig_type_info *) SWIG_TypeCheck(char *, _swig_type_info *);
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, _swig_type_info *, int);
SWIGEXPORT(void)              SWIG_MakePtr(char *c, void *, _swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, _swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, _swig_const_info constants[]);

/* External declarations when using runtime libraries */

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyBytes_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

static PyTypeObject varlinktype = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  (char*)"swigvarlink",                    /* Type name              */
  sizeof(swig_varlinkobject),              /* Basic size             */
  0,                                       /* Itemsize               */
  0,                                       /* Deallocator            */
#if PY_VERSION_HEX >= 0x03080000
  0,                                       /* Vector call            */
#else
  (printfunc) swig_varlink_print,          /* Print                  */
#endif
  (getattrfunc) swig_varlink_getattr,      /* Get attr               */
  (setattrfunc) swig_varlink_setattr,      /* Set attr               */
  0,                                       /* tp_as_async            */
  (reprfunc) swig_varlink_repr,            /* tp_repr                */
  0,                                       /* tp_as_number           */
  0,                                       /* tp_as_sequence         */
  0,                                       /* tp_as_mapping          */
  0,                                       /* tp_hash                */
  0,                                       /* tp_call                */
  0,                                       /* tp_str                 */
  0,                                       /* tp_getattro            */
  0,                                       /* tp_setattro            */
  0,                                       /* tp_as_buffer           */
  0,                                       /* tp_flags               */
  0,                                       /* tp_doc                 */
  0,                                       /* tp_traverse            */
  0,                                       /* tp_clear               */
  0,                                       /* tp_richcompare         */
  0,                                       /* tp_weaklistoffset      */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
  0,                                       /* tp_del                 */
  0,                                       /* tp_version_tag         */
  0,                                       /* tp_finalize            */
#if PY_VERSION_HEX >= 0x03100000
  0,                                       /* tp_vectorcall          */
#endif
};

/* Create a variable linking object for use later */
SWIGSTATICRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = PyObject_NEW(swig_varlinkobject, &varlinktype);
  if (result)
  {
    result->vars = 0;
  }
  return ((PyObject*) result);
}

SWIGSTATICRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
                PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}

/* -----------------------------------------------------------------------------
 * Pointer type-checking
 * ----------------------------------------------------------------------------- */

static _swig_type_info *swig_types = 0;

/* Register type mappings with the type-checker */
SWIGSTATICRUNTIME(_swig_type_info *)
SWIG_TypeRegister(_swig_type_info *ti) {
  _swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_types;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_types;
  swig_types = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGSTATICRUNTIME(_swig_type_info *) 
SWIG_TypeCheck(char *c, _swig_type_info *ty) {
  _swig_type_info *s;
  char *sn;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element is always just the name */
  while (s) {
    sn = s->name;
    if ((c == sn) || ((*c == *sn) && (strcmp(sn,c) == 0))) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Convert a pointer value */
SWIGSTATICRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, _swig_type_info *ty, int flags) {
  unsigned long p;
  int d;
  _swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;

  if (!obj || (obj == Py_None)) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    if ((!obj) || !(PyCObject_Check(obj))) goto type_error;
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  goto cobject;
#else
  if (!(PyByteArray_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyBytes_FromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    if ((!obj) || !(PyByteArray_Check(obj))) goto type_error;
  } 
  c = PyByteArray_AS_STRING(obj);
  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return 0;
  }
  c++;
  /* Extract hex value from pointer */
  while (d = *c) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    if (tc->converter) {
      *ptr = (*tc->converter)((void *) p);
    }
  }
  return 0;

type_error:
  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Take a pointer and convert it to a string */
SWIGSTATICRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, _swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[32], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

/* Create a new pointer object */
SWIGSTATICRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, _swig_type_info *type) {
  char result[512];
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, type->name, NULL);
#else
  SWIG_MakePtr(result,ptr,type);
  robj = PyBytes_FromString(result);
#endif
  return robj;
}

/* Install Constants */
SWIGSTATICRUNTIME(void)
SWIG_InstallConstants(PyObject *d, _swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyLong_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyBytes_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif


/* ---- TYPES TABLE (BEGIN) ---- */
#define  SWIGTYPE_KivioPage_p _swig_types[0] 
#define  SWIGTYPE_float_p _swig_types[1] 
#define  SWIGTYPE_KivioFillStyle_p _swig_types[2] 
#define  SWIGTYPE_KoRect_p _swig_types[3] 
#define  SWIGTYPE_KivioStencil_p _swig_types[4] 
#define  SWIGTYPE_KivioLayer_p _swig_types[5] 
static _swig_type_info *_swig_types[7];
/* ---- TYPES TABLE (END) ---- */

#define SWIG_init    initkivioc

#define SWIG_name    "kivioc"

  #include "config.h"

#include "kivio_stencil.h"

#include "kivio_layer.h"

#include "kivio_layers.h"
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_update(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":update")) 
        return NULL;
    update();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_isStencilSelected(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:isStencilSelected",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )isStencilSelected(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_selectAllStencils(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":selectAllStencils")) 
        return NULL;
    selectAllStencils();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_unselectAllStencils(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":unselectAllStencils")) 
        return NULL;
    unselectAllStencils();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_unselectStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:unselectStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )unselectStencil(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_selectStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:selectStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    selectStencil(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_curLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":curLayer")) 
        return NULL;
    _result = (KivioLayer *)curLayer();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_setCurLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:setCurLayer",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    setCurLayer(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_firstLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":firstLayer")) 
        return NULL;
    _result = (KivioLayer *)firstLayer();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_nextLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":nextLayer")) 
        return NULL;
    _result = (KivioLayer *)nextLayer();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_lastLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":lastLayer")) 
        return NULL;
    _result = (KivioLayer *)lastLayer();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_prevLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":prevLayer")) 
        return NULL;
    _result = (KivioLayer *)prevLayer();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_removeCurrentLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    bool  _result;
    self = self;
    if(!PyArg_ParseTuple(args,":removeCurrentLayer")) 
        return NULL;
    _result = (bool )removeCurrentLayer();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_addLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:addLayer",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    addLayer(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_insertLayer(PyObject *self, PyObject *args) {
    int  _arg0;
    PyObject  *_resultobj,*_argo1=0;
    KivioLayer  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"iO:insertLayer",&_arg0,&_argo1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    insertLayer(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_layerAt(PyObject *self, PyObject *args) {
    int  _arg0;
    PyObject  *_resultobj;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,"i:layerAt",&_arg0)) 
        return NULL;
    _result = (KivioLayer *)layerAt(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

static PyObject *_wrap_addStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:addStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )addStencil(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_deleteSelectedStencils(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":deleteSelectedStencils")) 
        return NULL;
    deleteSelectedStencils();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_groupSelectedStencils(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":groupSelectedStencils")) 
        return NULL;
    groupSelectedStencils();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_ungroupSelectedStencils(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":ungroupSelectedStencils")) 
        return NULL;
    ungroupSelectedStencils();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_bringToFront(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":bringToFront")) 
        return NULL;
    bringToFront();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_sendToBack(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":sendToBack")) 
        return NULL;
    sendToBack();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_copy(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":copy")) 
        return NULL;
    copy();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_cut(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":cut")) 
        return NULL;
    cut();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_paste(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    self = self;
    if(!PyArg_ParseTuple(args,":paste")) 
        return NULL;
    paste();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define new_KivioStencil() (new KivioStencil())
static PyObject *_wrap_new_KivioStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj;
    KivioStencil  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,":new_KivioStencil")) 
        return NULL;
    _result = (KivioStencil *)new_KivioStencil();
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define delete_KivioStencil(_swigobj) (delete _swigobj)
static PyObject *_wrap_delete_KivioStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_KivioStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    delete_KivioStencil(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_duplicate(_swigobj)  (_swigobj->duplicate())
static PyObject *_wrap_KivioStencil_duplicate(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result,*_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_duplicate",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioStencil_duplicate(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioStencil_x(_swigobj)  (_swigobj->x())
static PyObject *_wrap_KivioStencil_x(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_x",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_x(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_setX(_swigobj,_swigarg0)  (_swigobj->setX(_swigarg0))
static PyObject *_wrap_KivioStencil_setX(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setX",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setX(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_y(_swigobj)  (_swigobj->y())
static PyObject *_wrap_KivioStencil_y(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_y",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_y(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_setY(_swigobj,_swigarg0)  (_swigobj->setY(_swigarg0))
static PyObject *_wrap_KivioStencil_setY(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setY",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setY(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_w(_swigobj)  (_swigobj->w())
static PyObject *_wrap_KivioStencil_w(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_w",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_w(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_setW(_swigobj,_swigarg0)  (_swigobj->setW(_swigarg0))
static PyObject *_wrap_KivioStencil_setW(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setW",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setW(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_h(_swigobj)  (_swigobj->h())
static PyObject *_wrap_KivioStencil_h(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_h",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_h(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_setH(_swigobj,_swigarg0)  (_swigobj->setH(_swigarg0))
static PyObject *_wrap_KivioStencil_setH(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setH",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setH(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_rect(_swigobj)  (_swigobj->rect())
static PyObject *_wrap_KivioStencil_rect(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KoRect  *_result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_rect",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = new KoRect (KivioStencil_rect(_arg0));
    _resultobj = SWIG_NewPointerObj((void *)_result, SWIGTYPE_KoRect_p);
    return _resultobj;
}

#define KivioStencil_setPosition(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setPosition(_swigarg0,_swigarg1))
static PyObject *_wrap_KivioStencil_setPosition(PyObject *self, PyObject *args) {
    float  _arg1,_arg2;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Off:KivioStencil_setPosition",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setPosition(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setDimensions(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setDimensions(_swigarg0,_swigarg1))
static PyObject *_wrap_KivioStencil_setDimensions(PyObject *self, PyObject *args) {
    float  _arg1,_arg2;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Off:KivioStencil_setDimensions",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setDimensions(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_fillStyle(_swigobj)  (_swigobj->fillStyle())
static PyObject *_wrap_KivioStencil_fillStyle(PyObject *self, PyObject *args) {
    KivioFillStyle  *_result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_fillStyle",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (KivioFillStyle *)KivioStencil_fillStyle(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioFillStyle_p);
    return _resultobj;
}

#define KivioStencil_setLineWidth(_swigobj,_swigarg0)  (_swigobj->setLineWidth(_swigarg0))
static PyObject *_wrap_KivioStencil_setLineWidth(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setLineWidth",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setLineWidth(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_lineWidth(_swigobj)  (_swigobj->lineWidth())
static PyObject *_wrap_KivioStencil_lineWidth(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_lineWidth",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_lineWidth(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_hTextAlign(_swigobj)  (_swigobj->hTextAlign())
static PyObject *_wrap_KivioStencil_hTextAlign(PyObject *self, PyObject *args) {
    int  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_hTextAlign",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (int )KivioStencil_hTextAlign(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioStencil_vTextAlign(_swigobj)  (_swigobj->vTextAlign())
static PyObject *_wrap_KivioStencil_vTextAlign(PyObject *self, PyObject *args) {
    int  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_vTextAlign",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (int )KivioStencil_vTextAlign(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioStencil_setHTextAlign(_swigobj,_swigarg0)  (_swigobj->setHTextAlign(_swigarg0))
static PyObject *_wrap_KivioStencil_setHTextAlign(PyObject *self, PyObject *args) {
    int  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioStencil_setHTextAlign",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setHTextAlign(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setVTextAlign(_swigobj,_swigarg0)  (_swigobj->setVTextAlign(_swigarg0))
static PyObject *_wrap_KivioStencil_setVTextAlign(PyObject *self, PyObject *args) {
    int  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioStencil_setVTextAlign",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setVTextAlign(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static void  KivioStencil_setText(KivioStencil *self,char * s) { self->setText( TQString(s)); }
static PyObject *_wrap_KivioStencil_setText(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    char  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Os:KivioStencil_setText",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setText(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static char * KivioStencil_text(KivioStencil *self) { return (char*) self->text().latin1(); }
static PyObject *_wrap_KivioStencil_text(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    char  *_result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_text",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (char *)KivioStencil_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static char * KivioStencil_textColor(KivioStencil *self) { return (char*) TQString(self->textColor().name()).latin1(); }
static PyObject *_wrap_KivioStencil_textColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    char  *_result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_textColor",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (char *)KivioStencil_textColor(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static void  KivioStencil_setTextColor(KivioStencil *self,char * color) {  self->setTextColor(TQColor(color)); }
static PyObject *_wrap_KivioStencil_setTextColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    char  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Os:KivioStencil_setTextColor",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setTextColor(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static char * KivioStencil_fgColor(KivioStencil *self) { return (char*) TQString(self->fgColor().name()).latin1(); }
static PyObject *_wrap_KivioStencil_fgColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    char  *_result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_fgColor",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (char *)KivioStencil_fgColor(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static void  KivioStencil_setFGColor(KivioStencil *self,char * color) {  self->setFGColor(TQColor(color)); }
static PyObject *_wrap_KivioStencil_setFGColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    char  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Os:KivioStencil_setFGColor",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setFGColor(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static char * KivioStencil_bgColor(KivioStencil *self) { return (char*) TQString(self->bgColor().name()).latin1(); }
static PyObject *_wrap_KivioStencil_bgColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    char  *_result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_bgColor",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (char *)KivioStencil_bgColor(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static void  KivioStencil_setBGColor(KivioStencil *self,char * color) {  self->setBGColor(TQColor(color)); }
static PyObject *_wrap_KivioStencil_setBGColor(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    char  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Os:KivioStencil_setBGColor",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setBGColor(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_isSelected(_swigobj)  (_swigobj->isSelected())
static PyObject *_wrap_KivioStencil_isSelected(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_isSelected",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )KivioStencil_isSelected(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioStencil_select(_swigobj)  (_swigobj->select())
static PyObject *_wrap_KivioStencil_select(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_select",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_unselect(_swigobj)  (_swigobj->unselect())
static PyObject *_wrap_KivioStencil_unselect(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_unselect",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_unselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_subSelect(_swigobj,_swigarg0,_swigarg1)  (_swigobj->subSelect(_swigarg0,_swigarg1))
static PyObject *_wrap_KivioStencil_subSelect(PyObject *self, PyObject *args) {
    float  *_arg1,*_arg2;
    PyObject  *_resultobj,*_argo0=0,*_argo1=0,*_argo2=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"OOO:KivioStencil_subSelect",&_argo0,&_argo1,&_argo2)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_float_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo2,(void **) &_arg2,SWIGTYPE_float_p,1)) == -1) return NULL;
    KivioStencil_subSelect(_arg0,*_arg1,*_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_addToGroup(_swigobj,_swigarg0)  (_swigobj->addToGroup(_swigarg0))
static PyObject *_wrap_KivioStencil_addToGroup(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0,*_argo1=0;
    KivioStencil  *_arg0,*_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"OO:KivioStencil_addToGroup",&_argo0,&_argo1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_addToGroup(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_updateGeometry(_swigobj)  (_swigobj->updateGeometry())
static PyObject *_wrap_KivioStencil_updateGeometry(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_updateGeometry",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_updateGeometry(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setStartAHType(_swigobj,_swigarg0)  (_swigobj->setStartAHType(_swigarg0))
static PyObject *_wrap_KivioStencil_setStartAHType(PyObject *self, PyObject *args) {
    int  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioStencil_setStartAHType",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setStartAHType(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setStartAHWidth(_swigobj,_swigarg0)  (_swigobj->setStartAHWidth(_swigarg0))
static PyObject *_wrap_KivioStencil_setStartAHWidth(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setStartAHWidth",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setStartAHWidth(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setStartAHLength(_swigobj,_swigarg0)  (_swigobj->setStartAHLength(_swigarg0))
static PyObject *_wrap_KivioStencil_setStartAHLength(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setStartAHLength",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setStartAHLength(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setEndAHType(_swigobj,_swigarg0)  (_swigobj->setEndAHType(_swigarg0))
static PyObject *_wrap_KivioStencil_setEndAHType(PyObject *self, PyObject *args) {
    int  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioStencil_setEndAHType",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setEndAHType(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setEndAHWidth(_swigobj,_swigarg0)  (_swigobj->setEndAHWidth(_swigarg0))
static PyObject *_wrap_KivioStencil_setEndAHWidth(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setEndAHWidth",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setEndAHWidth(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_setEndAHLength(_swigobj,_swigarg0)  (_swigobj->setEndAHLength(_swigarg0))
static PyObject *_wrap_KivioStencil_setEndAHLength(PyObject *self, PyObject *args) {
    float  _arg1;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"Of:KivioStencil_setEndAHLength",&_argo0,&_arg1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    KivioStencil_setEndAHLength(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioStencil_startAHType(_swigobj)  (_swigobj->startAHType())
static PyObject *_wrap_KivioStencil_startAHType(PyObject *self, PyObject *args) {
    int  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_startAHType",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (int )KivioStencil_startAHType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioStencil_startAHWidth(_swigobj)  (_swigobj->startAHWidth())
static PyObject *_wrap_KivioStencil_startAHWidth(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_startAHWidth",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_startAHWidth(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_startAHLength(_swigobj)  (_swigobj->startAHLength())
static PyObject *_wrap_KivioStencil_startAHLength(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_startAHLength",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_startAHLength(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_endAHType(_swigobj)  (_swigobj->endAHType())
static PyObject *_wrap_KivioStencil_endAHType(PyObject *self, PyObject *args) {
    int  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_endAHType",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (int )KivioStencil_endAHType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioStencil_endAHWidth(_swigobj)  (_swigobj->endAHWidth())
static PyObject *_wrap_KivioStencil_endAHWidth(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_endAHWidth",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_endAHWidth(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define KivioStencil_endAHLength(_swigobj)  (_swigobj->endAHLength())
static PyObject *_wrap_KivioStencil_endAHLength(PyObject *self, PyObject *args) {
    float  _result;
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioStencil_endAHLength",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (float )KivioStencil_endAHLength(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

#define new_KivioLayer(_swigarg0) (new KivioLayer(_swigarg0))
static PyObject *_wrap_new_KivioLayer(PyObject *self, PyObject *args) {
    KivioPage  *_arg0;
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_result;
    self = self;
    if(!PyArg_ParseTuple(args,"O:new_KivioLayer",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioPage_p,1)) == -1) return NULL;
    _result = (KivioLayer *)new_KivioLayer(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioLayer_p);
    return _resultobj;
}

#define delete_KivioLayer(_swigobj) (delete _swigobj)
static PyObject *_wrap_delete_KivioLayer(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_KivioLayer",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    delete_KivioLayer(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioLayer_visible(_swigobj)  (_swigobj->visible())
static PyObject *_wrap_KivioLayer_visible(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_visible",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (bool )KivioLayer_visible(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioLayer_setVisible(_swigobj,_swigarg0)  (_swigobj->setVisible(_swigarg0))
static PyObject *_wrap_KivioLayer_setVisible(PyObject *self, PyObject *args) {
    int tempbool1;
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_arg0;
    bool  _arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioLayer_setVisible",&_argo0,&tempbool1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _arg1 = (bool ) tempbool1;
    KivioLayer_setVisible(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioLayer_connectable(_swigobj)  (_swigobj->connectable())
static PyObject *_wrap_KivioLayer_connectable(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    bool  _result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_connectable",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (bool )KivioLayer_connectable(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioLayer_setConnectable(_swigobj,_swigarg0)  (_swigobj->setConnectable(_swigarg0))
static PyObject *_wrap_KivioLayer_setConnectable(PyObject *self, PyObject *args) {
    int tempbool1;
    PyObject  *_resultobj,*_argo0=0;
    KivioLayer  *_arg0;
    bool  _arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"Oi:KivioLayer_setConnectable",&_argo0,&tempbool1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _arg1 = (bool ) tempbool1;
    KivioLayer_setConnectable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define KivioLayer_addStencil(_swigobj,_swigarg0)  (_swigobj->addStencil(_swigarg0))
static PyObject *_wrap_KivioLayer_addStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0,*_argo1=0;
    bool  _result;
    KivioLayer  *_arg0;
    KivioStencil  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"OO:KivioLayer_addStencil",&_argo0,&_argo1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )KivioLayer_addStencil(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioLayer_removeStencil(_swigobj,_swigarg0)  (_swigobj->removeStencil(_swigarg0))
static PyObject *_wrap_KivioLayer_removeStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0,*_argo1=0;
    bool  _result;
    KivioLayer  *_arg0;
    KivioStencil  *_arg1;
    self = self;
    if(!PyArg_ParseTuple(args,"OO:KivioLayer_removeStencil",&_argo0,&_argo1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (bool )KivioLayer_removeStencil(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define KivioLayer_firstStencil(_swigobj)  (_swigobj->firstStencil())
static PyObject *_wrap_KivioLayer_firstStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_firstStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_firstStencil(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioLayer_nextStencil(_swigobj)  (_swigobj->nextStencil())
static PyObject *_wrap_KivioLayer_nextStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_nextStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_nextStencil(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioLayer_prevStencil(_swigobj)  (_swigobj->prevStencil())
static PyObject *_wrap_KivioLayer_prevStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_prevStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_prevStencil(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioLayer_currentStencil(_swigobj)  (_swigobj->currentStencil())
static PyObject *_wrap_KivioLayer_currentStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_currentStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_currentStencil(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioLayer_lastStencil(_swigobj)  (_swigobj->lastStencil())
static PyObject *_wrap_KivioLayer_lastStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0;
    KivioStencil  *_result;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"O:KivioLayer_lastStencil",&_argo0)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_lastStencil(_arg0);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

#define KivioLayer_takeStencil(_swigobj,_swigarg0)  (_swigobj->takeStencil(_swigarg0))
static PyObject *_wrap_KivioLayer_takeStencil(PyObject *self, PyObject *args) {
    PyObject  *_resultobj,*_argo0=0,*_argo1=0;
    KivioStencil  *_result,*_arg1;
    KivioLayer  *_arg0;
    self = self;
    if(!PyArg_ParseTuple(args,"OO:KivioLayer_takeStencil",&_argo0,&_argo1)) 
        return NULL;
    if ((SWIG_ConvertPtr(_argo0,(void **) &_arg0,SWIGTYPE_KivioLayer_p,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(_argo1,(void **) &_arg1,SWIGTYPE_KivioStencil_p,1)) == -1) return NULL;
    _result = (KivioStencil *)KivioLayer_takeStencil(_arg0,_arg1);
    _resultobj = SWIG_NewPointerObj((void *) _result, SWIGTYPE_KivioStencil_p);
    return _resultobj;
}

static PyMethodDef kiviocMethods[] = {
  { "KivioLayer_takeStencil", _wrap_KivioLayer_takeStencil, METH_VARARGS, (char*)"KivioLayer_takeStencil" },
  { "KivioLayer_lastStencil", _wrap_KivioLayer_lastStencil, METH_VARARGS, (char*)"KivioLayer_lastStencil" },
  { "KivioLayer_currentStencil", _wrap_KivioLayer_currentStencil, METH_VARARGS, (char*)"KivioLayer_currentStencil" },
  { "KivioLayer_prevStencil", _wrap_KivioLayer_prevStencil, METH_VARARGS, (char*)"KivioLayer_prevStencil" },
  { "KivioLayer_nextStencil", _wrap_KivioLayer_nextStencil, METH_VARARGS, (char*)"KivioLayer_nextStencil" },
  { "KivioLayer_firstStencil", _wrap_KivioLayer_firstStencil, METH_VARARGS, (char*)"KivioLayer_firstStencil" },
  { "KivioLayer_removeStencil", _wrap_KivioLayer_removeStencil, METH_VARARGS, (char*)"KivioLayer_removeStencil" },
  { "KivioLayer_addStencil", _wrap_KivioLayer_addStencil, METH_VARARGS, (char*)"KivioLayer_addStencil" },
  { "KivioLayer_setConnectable", _wrap_KivioLayer_setConnectable, METH_VARARGS, (char*)"KivioLayer_setConnectable" },
  { "KivioLayer_connectable", _wrap_KivioLayer_connectable, METH_VARARGS, (char*)"KivioLayer_connectable" },
  { "KivioLayer_setVisible", _wrap_KivioLayer_setVisible, METH_VARARGS, (char*)"KivioLayer_setVisible" },
  { "KivioLayer_visible", _wrap_KivioLayer_visible, METH_VARARGS, (char*)"KivioLayer_visible" },
  { "delete_KivioLayer", _wrap_delete_KivioLayer, METH_VARARGS, (char*)"delete_KivioLayer" },
  { "new_KivioLayer", _wrap_new_KivioLayer, METH_VARARGS, (char*)"new_KivioLayer" },
  { "KivioStencil_endAHLength", _wrap_KivioStencil_endAHLength, METH_VARARGS, (char*)"KivioStencil_endAHLength" },
  { "KivioStencil_endAHWidth", _wrap_KivioStencil_endAHWidth, METH_VARARGS, (char*)"KivioStencil_endAHWidth" },
  { "KivioStencil_endAHType", _wrap_KivioStencil_endAHType, METH_VARARGS, (char*)"KivioStencil_endAHType" },
  { "KivioStencil_startAHLength", _wrap_KivioStencil_startAHLength, METH_VARARGS, (char*)"KivioStencil_startAHLength" },
  { "KivioStencil_startAHWidth", _wrap_KivioStencil_startAHWidth, METH_VARARGS, (char*)"KivioStencil_startAHWidth" },
  { "KivioStencil_startAHType", _wrap_KivioStencil_startAHType, METH_VARARGS, (char*)"KivioStencil_startAHType" },
  { "KivioStencil_setEndAHLength", _wrap_KivioStencil_setEndAHLength, METH_VARARGS, (char*)"KivioStencil_setEndAHLength" },
  { "KivioStencil_setEndAHWidth", _wrap_KivioStencil_setEndAHWidth, METH_VARARGS, (char*)"KivioStencil_setEndAHWidth" },
  { "KivioStencil_setEndAHType", _wrap_KivioStencil_setEndAHType, METH_VARARGS, (char*)"KivioStencil_setEndAHType" },
  { "KivioStencil_setStartAHLength", _wrap_KivioStencil_setStartAHLength, METH_VARARGS, (char*)"KivioStencil_setStartAHLength" },
  { "KivioStencil_setStartAHWidth", _wrap_KivioStencil_setStartAHWidth, METH_VARARGS, (char*)"KivioStencil_setStartAHWidth" },
  { "KivioStencil_setStartAHType", _wrap_KivioStencil_setStartAHType, METH_VARARGS, (char*)"KivioStencil_setStartAHType" },
  { "KivioStencil_updateGeometry", _wrap_KivioStencil_updateGeometry, METH_VARARGS, (char*)"KivioStencil_updateGeometry" },
  { "KivioStencil_addToGroup", _wrap_KivioStencil_addToGroup, METH_VARARGS, (char*)"KivioStencil_addToGroup" },
  { "KivioStencil_subSelect", _wrap_KivioStencil_subSelect, METH_VARARGS, (char*)"KivioStencil_subSelect" },
  { "KivioStencil_unselect", _wrap_KivioStencil_unselect, METH_VARARGS, (char*)"KivioStencil_unselect" },
  { "KivioStencil_select", _wrap_KivioStencil_select, METH_VARARGS, (char*)"KivioStencil_select" },
  { "KivioStencil_isSelected", _wrap_KivioStencil_isSelected, METH_VARARGS, (char*)"KivioStencil_isSelected" },
  { "KivioStencil_setBGColor", _wrap_KivioStencil_setBGColor, METH_VARARGS, (char*)"KivioStencil_setBGColor" },
  { "KivioStencil_bgColor", _wrap_KivioStencil_bgColor, METH_VARARGS, (char*)"KivioStencil_bgColor" },
  { "KivioStencil_setFGColor", _wrap_KivioStencil_setFGColor, METH_VARARGS, (char*)"KivioStencil_setFGColor" },
  { "KivioStencil_fgColor", _wrap_KivioStencil_fgColor, METH_VARARGS, (char*)"KivioStencil_fgColor" },
  { "KivioStencil_setTextColor", _wrap_KivioStencil_setTextColor, METH_VARARGS, (char*)"KivioStencil_setTextColor" },
  { "KivioStencil_textColor", _wrap_KivioStencil_textColor, METH_VARARGS, (char*)"KivioStencil_textColor" },
  { "KivioStencil_text", _wrap_KivioStencil_text, METH_VARARGS, (char*)"KivioStencil_text" },
  { "KivioStencil_setText", _wrap_KivioStencil_setText, METH_VARARGS, (char*)"KivioStencil_setText" },
  { "KivioStencil_setVTextAlign", _wrap_KivioStencil_setVTextAlign, METH_VARARGS, (char*)"KivioStencil_setVTextAlign" },
  { "KivioStencil_setHTextAlign", _wrap_KivioStencil_setHTextAlign, METH_VARARGS, (char*)"KivioStencil_setHTextAlign" },
  { "KivioStencil_vTextAlign", _wrap_KivioStencil_vTextAlign, METH_VARARGS, (char*)"KivioStencil_vTextAlign" },
  { "KivioStencil_hTextAlign", _wrap_KivioStencil_hTextAlign, METH_VARARGS, (char*)"KivioStencil_hTextAlign" },
  { "KivioStencil_lineWidth", _wrap_KivioStencil_lineWidth, METH_VARARGS, (char*)"KivioStencil_lineWidth" },
  { "KivioStencil_setLineWidth", _wrap_KivioStencil_setLineWidth, METH_VARARGS, (char*)"KivioStencil_setLineWidth" },
  { "KivioStencil_fillStyle", _wrap_KivioStencil_fillStyle, METH_VARARGS, (char*)"KivioStencil_fillStyle" },
  { "KivioStencil_setDimensions", _wrap_KivioStencil_setDimensions, METH_VARARGS, (char*)"KivioStencil_setDimensions" },
  { "KivioStencil_setPosition", _wrap_KivioStencil_setPosition, METH_VARARGS, (char*)"KivioStencil_setPosition" },
  { "KivioStencil_rect", _wrap_KivioStencil_rect, METH_VARARGS, (char*)"KivioStencil_rect" },
  { "KivioStencil_setH", _wrap_KivioStencil_setH, METH_VARARGS, (char*)"KivioStencil_setH" },
  { "KivioStencil_h", _wrap_KivioStencil_h, METH_VARARGS, (char*)"KivioStencil_h" },
  { "KivioStencil_setW", _wrap_KivioStencil_setW, METH_VARARGS, (char*)"KivioStencil_setW" },
  { "KivioStencil_w", _wrap_KivioStencil_w, METH_VARARGS, (char*)"KivioStencil_w" },
  { "KivioStencil_setY", _wrap_KivioStencil_setY, METH_VARARGS, (char*)"KivioStencil_setY" },
  { "KivioStencil_y", _wrap_KivioStencil_y, METH_VARARGS, (char*)"KivioStencil_y" },
  { "KivioStencil_setX", _wrap_KivioStencil_setX, METH_VARARGS, (char*)"KivioStencil_setX" },
  { "KivioStencil_x", _wrap_KivioStencil_x, METH_VARARGS, (char*)"KivioStencil_x" },
  { "KivioStencil_duplicate", _wrap_KivioStencil_duplicate, METH_VARARGS, (char*)"KivioStencil_duplicate" },
  { "delete_KivioStencil", _wrap_delete_KivioStencil, METH_VARARGS, (char*)"delete_KivioStencil" },
  { "new_KivioStencil", _wrap_new_KivioStencil, METH_VARARGS, (char*)"new_KivioStencil" },
  { "paste", _wrap_paste, METH_VARARGS, (char*)"paste" },
  { "cut", _wrap_cut, METH_VARARGS, (char*)"cut" },
  { "copy", _wrap_copy, METH_VARARGS, (char*)"copy" },
  { "sendToBack", _wrap_sendToBack, METH_VARARGS, (char*)"sendToBack" },
  { "bringToFront", _wrap_bringToFront, METH_VARARGS, (char*)"bringToFront" },
  { "ungroupSelectedStencils", _wrap_ungroupSelectedStencils, METH_VARARGS, (char*)"ungroupSelectedStencils" },
  { "groupSelectedStencils", _wrap_groupSelectedStencils, METH_VARARGS, (char*)"groupSelectedStencils" },
  { "deleteSelectedStencils", _wrap_deleteSelectedStencils, METH_VARARGS, (char*)"deleteSelectedStencils" },
  { "addStencil", _wrap_addStencil, METH_VARARGS, (char*)"addStencil" },
  { "layerAt", _wrap_layerAt, METH_VARARGS, (char*)"layerAt" },
  { "insertLayer", _wrap_insertLayer, METH_VARARGS, (char*)"insertLayer" },
  { "addLayer", _wrap_addLayer, METH_VARARGS, (char*)"addLayer" },
  { "removeCurrentLayer", _wrap_removeCurrentLayer, METH_VARARGS, (char*)"removeCurrentLayer" },
  { "prevLayer", _wrap_prevLayer, METH_VARARGS, (char*)"prevLayer" },
  { "lastLayer", _wrap_lastLayer, METH_VARARGS, (char*)"lastLayer" },
  { "nextLayer", _wrap_nextLayer, METH_VARARGS, (char*)"nextLayer" },
  { "firstLayer", _wrap_firstLayer, METH_VARARGS, (char*)"firstLayer" },
  { "setCurLayer", _wrap_setCurLayer, METH_VARARGS, (char*)"setCurLayer" },
  { "curLayer", _wrap_curLayer, METH_VARARGS, (char*)"curLayer" },
  { "selectStencil", _wrap_selectStencil, METH_VARARGS, (char*)"selectStencil" },
  { "unselectStencil", _wrap_unselectStencil, METH_VARARGS, (char*)"unselectStencil" },
  { "unselectAllStencils", _wrap_unselectAllStencils, METH_VARARGS, (char*)"unselectAllStencils" },
  { "selectAllStencils", _wrap_selectAllStencils, METH_VARARGS, (char*)"selectAllStencils" },
  { "isStencilSelected", _wrap_isStencilSelected, METH_VARARGS, (char*)"isStencilSelected" },
  { "update", _wrap_update, METH_VARARGS, (char*)"update" },
  { NULL, NULL }
};
#ifdef __cplusplus
}
#endif
static _swig_type_info _swigt__KivioPage_p[] = {{"_KivioPage_p",0},{"_KivioPage_p",0},{0}};
static _swig_type_info _swigt__float_p[] = {{"_float_p",0},{"_float_p",0},{0}};
static _swig_type_info _swigt__KivioFillStyle_p[] = {{"_KivioFillStyle_p",0},{"_KivioFillStyle_p",0},{0}};
static _swig_type_info _swigt__KoRect_p[] = {{"_KoRect_p",0},{"_KoRect_p",0},{0}};
static _swig_type_info _swigt__KivioStencil_p[] = {{"_KivioStencil_p",0},{"_KivioStencil_p",0},{0}};
static _swig_type_info _swigt__KivioLayer_p[] = {{"_KivioLayer_p",0},{"_KivioLayer_p",0},{0}};

static _swig_type_info *_swig_types_initial[] = {
_swigt__KivioPage_p, 
_swigt__float_p, 
_swigt__KivioFillStyle_p, 
_swigt__KoRect_p, 
_swigt__KivioStencil_p, 
_swigt__KivioLayer_p, 
0
};

static _swig_const_info _swig_const_table[] = {
{0}};

static struct PyModuleDef kivio_module = {
  PyModuleDef_HEAD_INIT,
  "kivioc",
  NULL,
  -1,
  kiviocMethods,
  NULL,
  NULL,
  NULL,
  NULL
};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initkivioc(void)
{
  PyObject *m, *d;
  SWIG_globals = SWIG_newvarlink();
  m = PyModule_Create(&kivio_module);
  d = PyModule_GetDict(m);
  {
    int i;
    for (i = 0; _swig_types_initial[i]; i++) {
      _swig_types[i] = SWIG_TypeRegister(_swig_types_initial[i]);
    }
  }
  SWIG_InstallConstants(d,_swig_const_table);
}
#endif // HAVE_PYTHON

