###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for taglib

pkg_search_module( TAGLIB taglib )
if( TAGLIB_FOUND )
  if( ${TAGLIB_VERSION} VERSION_LESS "1.4" )
    tde_message_fatal( "taglib version must be at least 1.4" )
  else( )
    message( STATUS "Found TAGLIB: ${TAGLIB_INCLUDE_DIRS}" )
  endif( )
else( )
  tde_message_fatal( "taglib is required, but not found on your system" )
endif( )


##### check for cdda interface and paranoia

message( STATUS "Checking for CDParanonia" )
find_path( CDPARANOIA_INCLUDE_DIR cdda_interface.h PATH_SUFFIXES cdda )
find_library( CDPARANOIA_LIBRARY NAMES cdda_paranoia )
find_library( CDPARANOIA_IF_LIBRARY NAMES cdda_interface )
if( CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY )
  set( CDPARANOIA_LIBRARIES ${CDPARANOIA_LIBRARY} ${CDPARANOIA_IF_LIBRARY} )
else( )
  tde_message_fatal( "CDParanoia is required, but not found on your system" )
endif( )
