/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPBOOKMARKACTION_H
#define KFTPBOOKMARKACTION_H

#include <tdeaction.h>
#include <kurl.h>
#include <tdeversion.h>

#include <tqdom.h>

#include "kftpzeroconf.h"

namespace KFTPBookmarks {
  class Site;
}

/**
 * This class represents a bookmark TDEAction that executes a connection to
 * the bookmarked site.
 *
 * @author Jernej Kos
 */
class KFTPWalletAction : public TDEAction
{
TQ_OBJECT
public:
    KFTPWalletAction(const TQString &text, const TQString &pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name = 0);
  
    void setSite(const KURL &site) { m_site = site; };
    KURL getSite() { return m_site; }
private:
    KURL m_site;
};

/**
 * This class represents a zeroconf TDEAction that executes a connection to
 * the zeroconf resolved site.
 *
 * @author Jernej Kos
 */
class KFTPZeroconfAction : public TDEAction
{
TQ_OBJECT
public:
    KFTPZeroconfAction(const TQString &text, const TQString &pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name = 0);
    void setSite(DNSSD::RemoteService::Ptr service);
    DNSSD::RemoteService::Ptr getSite() { return m_service; }
private:
    DNSSD::RemoteService::Ptr m_service;
};

/**
 * This class represents a bookmark TDEAction that executes a connection to
 * the bookmarked site.
 *
 * @author Jernej Kos
 */
class KFTPBookmarkAction : public TDEAction
{
TQ_OBJECT
public:
    KFTPBookmarkAction(const TQString &text, const TQString &pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name = 0);
    
    void setSiteId(const TQString &id) { m_siteId = id; }
    void setData(TQObject *data) { m_data = data; }
    
    TQObject *data() { return m_data; }
    TQString siteId() { return m_siteId; }
private:
    TQObject *m_data;
    TQString m_siteId;
};

#endif
