#ifndef SCORE_H
#define SCORE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <kapp.h>

#include <tqwidget.h>
#include <tqstring.h>
#include <tqpoint.h>
#include <tqrect.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqdatetime.h>

#include "painter.h"
#include "bitfont.h"

#define maxPlayer 1
#define minPlayerNameLength 3
#define highscoreName "highscore"

class Score : public TQWidget
{
    TQ_OBJECT
public:
    Score (TQWidget *parent=0, const char *name=0, int scheme=-1, int mode=-1, Bitfont *font=0);
    ~Score();

public slots:
    void setScheme(int scheme, int mode, Bitfont *font=0);

    void set(int score);
    void set(int score, int player);
    void setScore(int level, int player);
    void setPause(bool paused);

    void initKeys();

private slots:
    void read();
    void write();
    void end();

signals:
    void gameFinished();
    void gameHighscores();

protected:
    void timerEvent(TQTimerEvent *);
    void paintEvent(TQPaintEvent *);
    void keyPressEvent(TQKeyEvent *);

    void focusInEvent(TQFocusEvent *) { ; }
    void focusOutEvent(TQFocusEvent *) { ; }

    void confScheme();
    void confTiming(bool defGroup=TRUE);

private:
    Bitfont *bitfont;

    TQRect rect(int col, float row, TQString str, int align = AlignCenter);
    int x(int col);
    int y(float row);

    TQString formatDate(TQDate date);

		/**
		 * Ermittelt die zu benutzende "highscore"-Datei, in die auch geschrieben werden kann.
		 * ber den "highscoreFilePath"-TDEConfig-Eintrag, kann abweichend von der Standardlokation
		 * der Standort der "highscore"-Datei spezifiziert werden.
		 * Wenn die systemweite "globale" Datei nicht beschrieben werden kann, wird mit einer
		 * privaten Datei gearbeitet.
		 */
    TQFileInfo locateHighscoreFilePath();

    int cursorBlinkMS;
    int hallOfFameMS;
    int afterPauseMS;

    bool paused;

    uint UpKey;
    uint DownKey;
    uint RightKey;
    uint LeftKey;

    int lastScore;
    int lastPlayer;
    int HighScore;
    int playerScore[maxPlayer];
    TQString playerName[maxPlayer];

    struct {
        int x;
        int y;
        TQChar chr;
        bool on;
    } cursor;

    int cursorBlinkTimer;
    bool scrollRepeat;

    struct {
        int points;
        int levels;
        TQTime duration;
        TQDateTime moment;
        TQString name;
    } hallOfFame[10];

    TQFileInfo systemHighscoreFileInfo;
    TQFileInfo privateHighscoreFileInfo;

    TQFile highscoreFile;

    int scheme;
    int mode;
};

#endif // SCORE_H
