# Copyright 1999-2022 Gentoo Authors
# Copyright 2022 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_NAME="tdebase"
TRINITY_MODULE_TYPE="core"
TSM_EXTRACT="tdeioslave"
inherit trinity-meta-2

DESCRIPTION="Generic Trinity TDEIOslaves"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="+hwlib ldap openexr samba sasl sftp"

DEPEND="
	net-libs/rpcsvc-proto
	x11-libs/libXcursor
	net-libs/libtirpc
	ldap? ( net-nds/openldap )
	openexr? ( media-libs/openexr )
	samba? ( net-fs/samba )
	sftp? ( net-libs/libssh[sftp] )
	sasl? ( dev-libs/cyrus-sasl )
"

RDEPEND="${DEPEND}
	~trinity-base/tdeeject-${PV}
"

src_configure() {
	local mycmakeargs=(
		-DWITH_XCURSOR=ON
		-DWITH_SAMBA="$(usex samba)"
		-DWITH_LDAP="$(usex ldap)"
		-DWITH_SFTP="$(usex sftp)"
		-DWITH_SASL="$(usex sasl)"
		-DWITH_OPENEXR="$(usex openexr)"
		-DWITH_TDEHWLIB="$(usex hwlib)"
	)

	trinity-meta-2_src_configure
}
