# Copyright 2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="libraries"
PYTHON_COMPAT=( python3_{8..12} )
DISTUTILS_SINGLE_IMPL=1
inherit trinity-base-2 distutils-r1

DESCRIPTION="Python extensions for TDE"
HOMEPAGE="https://trinitydesktop.org/"
LICENSE="GPL-2"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE=""
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~dev-python/pytde-${PV}
"
RDEPEND="${DEPEND}"

TQBASE="/usr/tqt3"

src_compile() {
	local BUILD_DIR="${S}_${EPYTHON}"
	esetup.py build_libpythonize
	unset BUILD_DIR
	distutils-r1_src_compile
}

src_install() {
	distutils-r1_src_install
}
