 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_RESOURCEGROUPWISE_H
#define KCAL_RESOURCEGROUPWISE_H

#include <libemailfunctions/idmapper.h>

#include <libtdepim/progressmanager.h>

#include <libkcal/resourcecached.h>

#include <tdeabc/locknull.h>
#include <tdeio/job.h>
#include <tdeconfig.h>
#include <kdemacros.h>

class ngwt__Settings;

namespace KCal {

class GroupwisePrefsBase;

/**
  This class provides a resource for accessing a Groupwise calendar.
*/
class KDE_EXPORT ResourceGroupwise : public ResourceCached
{
  TQ_OBJECT
  

  public:
    ResourceGroupwise();
  
    ResourceGroupwise( const TDEConfig * );
    virtual ~ResourceGroupwise();

    void readConfig( const TDEConfig *config );
    void writeConfig( TDEConfig *config );

    GroupwisePrefsBase *prefs();

    bool doOpen();
    void doClose();

    bool doLoad();
    bool doSave();

    TDEABC::Lock *lock();

    bool userSettings( ngwt__Settings * &settings );
    bool modifyUserSettings( TQMap<TQString, TQString> & settings );
 protected:
    void init();

    bool confirmSave();

  protected slots:
    void slotJobResult( TDEIO::Job * );
    void slotJobData( TDEIO::Job *, const TQByteArray & );

    void cancelLoad();

  private:
    GroupwisePrefsBase *mPrefs;
    TDEABC::LockNull mLock;

    TDEIO::TransferJob *mDownloadJob;
    KPIM::ProgressItem *mProgress;
    TQString mJobData;

    bool mIsShowingError;
};

}

#endif
