/*
 * securestream.h - combines a ByteStream with TLS and SASL
 * Copyright (C) 2004  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SECURESTREAM_H
#define SECURESTREAM_H

#include <tqca.h>
#include "bytestream.h"

#define USE_TLSHANDLER

#ifdef USE_TLSHANDLER
namespace XMPP
{
	class TLSHandler;
}
#endif

class SecureStream : public ByteStream
{
	TQ_OBJECT
  
public:
	enum Error { ErrTLS = ErrCustom, ErrSASL };
	SecureStream(ByteStream *s);
	~SecureStream();

	void startTLSClient(TQCA::TLS *t, const TQByteArray &spare=TQByteArray());
	void startTLSServer(TQCA::TLS *t, const TQByteArray &spare=TQByteArray());
	void setLayerSASL(TQCA::SASL *s, const TQByteArray &spare=TQByteArray());
#ifdef USE_TLSHANDLER
	void startTLSClient(XMPP::TLSHandler *t, const TQString &server, const TQByteArray &spare=TQByteArray());
#endif

	void closeTLS();
	int errorCode() const;

	// reimplemented
	bool isOpen() const;
	void write(const TQByteArray &);
	int bytesToWrite() const;

signals:
	void tlsHandshaken();
	void tlsClosed();

private slots:
	void bs_readyRead();
	void bs_bytesWritten(int);

	void layer_tlsHandshaken();
	void layer_tlsClosed(const TQByteArray &);
	void layer_readyRead(const TQByteArray &);
	void layer_needWrite(const TQByteArray &);
	void layer_error(int);

private:
	void linkLayer(TQObject *);
	int calcPrebytes() const;
	void insertData(const TQByteArray &a);
	void writeRawData(const TQByteArray &a);
	void incomingData(const TQByteArray &a);

	class Private;
	Private *d;
};

#endif
