/***************************************************************************
                          TDEProcessConnect.cpp  -  description
                             -------------------
    begin                : Tue May 2 2000
    copyright            : (C) 2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          FILENAME|  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) |1995-2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include "TDEProcessConnect.h"

#include "TDEProcessConnect.moc"

TDEProcessConnect::TDEProcessConnect()
  : KChildConnect()
{
  running=false;
  process=0;
}

TDEProcessConnect::~TDEProcessConnect()
{
  Exit();
  delete process;
//  printf("DESTRUCTRING KPROCESSCONNECT\n");
}

bool TDEProcessConnect::Init(int id,KEMessage *msg)
{
  int size;
  char *p;

  SetID(id);
  if (msg)
  {
    if (!msg->GetData(TQCString("ProcessName"),p,size)) return false; // no process name
    processname=p;
    /*
    printf("Found processname '%s' size %d size=%u\n",
       p,size,msg->QueryNumberOfKeys());
    */
    msg->Remove(TQCString("ProcessName"));
  }
  if (processname.length()<1) return false;

  inputbuffer="";

  // Delete first on multiple init
  if (running) Exit();

  // create process
  process=new TDEProcess;
  *process << processname;
  connect(process, TQ_SIGNAL(receivedStdout(TDEProcess *, char *, int )),
                        this, TQ_SLOT(slotReceivedStdout(TDEProcess *, char * , int )));
  connect(process, TQ_SIGNAL(processExited(TDEProcess *)),
                        this, TQ_SLOT(slotProcessExited(TDEProcess *)));
  /*
  connect(process, TQ_SIGNAL(wroteStdin(TDEProcess *)),
                        this, TQ_SLOT(slotWroteStdin(TDEProcess *)));
  */

  // TRUE if ok
  running=process->start(TDEProcess::NotifyOnExit,TDEProcess::All);

  if (running && msg && msg->QueryNumberOfKeys()>0)
  {
    SendMsg(msg);
  }

  return running;
}

void TDEProcessConnect::slotReceivedStdout(TDEProcess *, char *buffer, int buflen)
{
  TQString s;
  char c;
  int pos;

  if (buflen<1) return ;
  if (buffer[buflen-1]!=0) // shit..we got a not null terminated string
  {
    c=buffer[buflen-1];
    buffer[buflen-1]=0;
    s=buffer;
    s+=c;
  }
  else
  {
    s=buffer;
  }
  // Append old unresolved input
  s=inputbuffer+s;
  pos=s.findRev(KEMESSAGE_CR);
  // printf("String '%s' pos=%d len=%d\n",(const char *)s,pos,s.length());
  if (pos<0)
  {
    inputbuffer=s;
  }
  else if (pos+KEMESSAGE_CR.length()==s.length())
  {
    // CR at the end...calling receive
    Receive(s);
  }
  else
  {
    inputbuffer=s.right(s.length()-pos-KEMESSAGE_CR.length());
    s=s.left(pos+KEMESSAGE_CR.length());
    // printf("s='%s' in='%s'\n",(const char *)s,(const char *)inputbuffer);
    Receive(s);
  }
}
void TDEProcessConnect::slotProcessExited(TDEProcess *)
{
  running=false;
  delete process;
  process=0;
  Init(QueryID());
}
void TDEProcessConnect::slotWroteStdin(TDEProcess *)
{
  printf("slotWroteStdin:: IS NEVER CALLED\n");
}

bool TDEProcessConnect::Exit()
{
  // kill process if running
  if (running)
  {
    running=false;
    if (process) process->kill();
    delete process;
    process=0;
  }
  return true;
}

bool TDEProcessConnect::Next()
{
  bool result;
  if (!running) return false;
  // create and send message
  // printf("+- TDEProcessConnect::ProcessNext\n");
  KEMessage *msg=new KEMessage;
  // User fills message
  emit signalPrepareMove(msg,KG_INPUTTYPE_PROCESS);
  result=SendMsg(msg);
  delete msg;
  return result;
}

// Send string to child
bool TDEProcessConnect::Send(TQString str)
{
  bool result;
  // printf("****** PROCESS:SEND\n");
  if (!running || !process) return false;
  if (!str || str.length()<1) return true; // no need to send crap
  // TODO ..why?
  TQString s;
  s=KEMESSAGE_CR+KEMESSAGE_CR;
  str=s+str;
  // printf("+++ Sending to child '%s'!!!\n",(const char *)str);
  result=process->writeStdin(str.latin1(),str.length()+1);
  if (!result) printf("ERROR in PROCESS SEND\n");
  return result;
}

