/*
    This file is part of the TDE games library
    Copyright (C) 2004 Nicolas Hadacek (hadacek@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/


#include "kzoommainwindow.h"
#include "kzoommainwindow.moc"

#include <tdeaction.h>
#include <kstdaction.h>
#include <tdemenubar.h>
#include <kcmenumngr.h>


KZoomMainWindow::KZoomMainWindow(uint min, uint max, uint step, 
				 const char *name)
  : TDEMainWindow(0, name), m_zoomStep(step), m_minZoom(min), m_maxZoom(max)
{
  installEventFilter(this);
  
  m_zoomInAction = 
    KStdAction::zoomIn(this, TQ_SLOT(zoomIn()), actionCollection());
  m_zoomOutAction =
    KStdAction::zoomOut(this, TQ_SLOT(zoomOut()), actionCollection());
  m_menu =
    KStdAction::showMenubar(this, TQ_SLOT(toggleMenubar()), actionCollection());
}


void KZoomMainWindow::init(const char *popupName)
{
  // zoom
  setZoom(readZoomSetting());

  // menubar
  m_menu->setChecked( menubarVisibleSetting() );  
  toggleMenubar();
  
  // context popup
  if (popupName) {
    TQPopupMenu *popup =
      static_cast<TQPopupMenu *>(factory()->container(popupName, this));
    Q_ASSERT(popup);
    if (popup)
      KContextMenuManager::insert(this, popup);
  }
}

void KZoomMainWindow::addWidget(TQWidget *widget)
{
  widget->adjustSize();

  TQWidget          *tlw = widget->topLevelWidget();
  KZoomMainWindow  *zm = 
    static_cast<KZoomMainWindow *>(tlw->tqt_cast("KZoomMainWindow"));

  Q_ASSERT(zm);
  zm->m_widgets.append(widget);
  connect(widget, TQ_SIGNAL(destroyed()), zm, TQ_SLOT(widgetDestroyed()));
}


void KZoomMainWindow::widgetDestroyed()
{
  m_widgets.remove(static_cast<const TQWidget *>(sender()));
}


bool KZoomMainWindow::eventFilter(TQObject *o, TQEvent *e)
{
  if ( e->type()==TQEvent::LayoutHint )
    setFixedSize(minimumSize()); // because K/TQMainWindow
                                 // does not manage fixed central widget
                                 // with hidden menubar...
  return TDEMainWindow::eventFilter(o, e);
}


void KZoomMainWindow::setZoom(uint zoom)
{
  m_zoom = zoom;
  writeZoomSetting(m_zoom);

  TQPtrListIterator<TQWidget>  it(m_widgets);
  for (; it.current(); ++it)
    (*it)->adjustSize();

  m_zoomOutAction->setEnabled( m_zoom > m_minZoom );
  m_zoomInAction->setEnabled( m_zoom < m_maxZoom );
}


void KZoomMainWindow::zoomIn()
{
  setZoom(m_zoom + m_zoomStep);
}


void KZoomMainWindow::zoomOut()
{
  Q_ASSERT( m_zoom >= m_zoomStep );
  setZoom(m_zoom - m_zoomStep);
}


void KZoomMainWindow::toggleMenubar()
{
  if ( m_menu->isChecked() )
    menuBar()->show();
  else
    menuBar()->hide();
}


bool KZoomMainWindow::queryExit()
{
  writeMenubarVisibleSetting(m_menu->isChecked());

  return TDEMainWindow::queryExit();
}
