/* 
  Copyright (C) 2006 Montel Laurent <lmontel@mandriva.com>
  based on plastik
   Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

  based on the window decoration "Web":
  Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
 */

#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqslider.h>
#include <tqspinbox.h>
#include <tqwhatsthis.h>

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeglobal.h>

#include "config.h"
#include "configdialog.h"

IaOraConfig::IaOraConfig(TDEConfig* config, TQWidget* parent)
    : TQObject(parent), m_config(0), m_dialog(0)
{
    // create the configuration object
    m_config = new TDEConfig("twiniaorarc");
    TDEGlobal::locale()->insertCatalogue("twin_clients");
    TDEGlobal::locale()->insertCatalogue("twin_iaora");

    // create and show the configuration dialog
    m_dialog = new ConfigDialog(parent);
    m_dialog->show();

    // load the configuration
    load(config);

    // setup the connections
    connect(m_dialog->menuClose, TQ_SIGNAL(toggled(bool)),
            this, TQ_SIGNAL(changed()));
    connect(m_dialog->titleShadow, TQ_SIGNAL(toggled(bool)),
            this, TQ_SIGNAL(changed()));
}

IaOraConfig::~IaOraConfig()
{
    delete m_dialog;
    delete m_config;
}

void IaOraConfig::load(TDEConfig*)
{
    m_config->setGroup("General");

    bool menuClose = m_config->readBoolEntry("CloseOnMenuDoubleClick", true);
    m_dialog->menuClose->setChecked(menuClose);
    bool titleShadow = m_config->readBoolEntry("TitleShadow", true);
    m_dialog->titleShadow->setChecked(titleShadow);
}

void IaOraConfig::save(TDEConfig*)
{
    m_config->setGroup("General");

    m_config->writeEntry("CloseOnMenuDoubleClick", m_dialog->menuClose->isChecked() );
    m_config->writeEntry("TitleShadow", m_dialog->titleShadow->isChecked() );
    m_config->sync();
}

void IaOraConfig::defaults()
{
    m_dialog->menuClose->setChecked(false);
    m_dialog->titleShadow->setChecked(true);
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    KDE_EXPORT TQObject* allocate_config(TDEConfig* config, TQWidget* parent) {
        return (new IaOraConfig(config, parent));
    }
}

#include "config.moc"
