/*
	Copyright (C) 2006 Michael Lentner <michaell@gmx.net>
	
	based on KDE2 Default configuration widget:
	Copyright (c) 2001
		Karol Szwed <gallium@kde.org>
		http://gallium.n3.net/
	
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Library General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include "dominoConfig.h"
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqsettings.h>

extern "C"
{
	KDE_EXPORT TQObject* allocate_config( TDEConfig* config, TQWidget* parent )
	{
		return(new DominoConfig(config, parent));
	}
}

// NOTE:
// 'config' is a pointer to the twindecoration modules open twin config,
//		  and is by default set to the "Style" group.
// 'parent' is the parent of the TQObject, which is a VBox inside the
//		  Configure tab in twindecoration

DominoConfig::DominoConfig( TDEConfig* config, TQWidget* parent )
	: TQObject( parent )
{
	conf = new TDEConfig("twindominorc");

	TDEGlobal::locale()->insertCatalogue("twin_clients");
	TDEGlobal::locale()->insertCatalogue("twin_domino");

	vBox = new TQVBox( parent );

	customBorderColor = new TQCheckBox( i18n("Custom border color"), vBox );
	TQHBox *hbox1 = new TQHBox(vBox);
	hbox1->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	borderColor = new KColorButton(hbox1);
	
	customButtonColor = new TQCheckBox( i18n("Custom button color"), vBox );
	TQHBox *hbox2 = new TQHBox(vBox);
	hbox2->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	buttonColor = new KColorButton(hbox2);
	
	customButtonIconColor = new TQCheckBox( i18n("Custom button icon color"), vBox );
	TQHBox *hbox3 = new TQHBox(vBox);
	hbox3->layout()->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	buttonIconColor = new KColorButton(hbox3);
	
	customGradientColors = new TQCheckBox( i18n("Custom gradient colors"), vBox);
	TQHBox *hbox4 = new TQHBox(vBox);
	hbox4->layout()->addItem(new TQSpacerItem(22, 0, TQSizePolicy::Fixed, TQSizePolicy::Minimum) );
	
	TQVBox *vbox1 = new TQVBox(hbox4);
	new TQLabel( i18n("Top gradient color"), vbox1);
	topGradientColor = new KColorButton(vbox1);
	new TQLabel(i18n("Bottom gradient color"), vbox1);
	bottomGradientColor = new KColorButton(vbox1);
	
	showInactiveButtons = new TQCheckBox( i18n("Show inactive buttons"), vBox );
	showButtonIcons  = new TQCheckBox( i18n("Show button icons"), vBox );
	darkFrame  = new TQCheckBox( i18n("Dark window frame"), vBox );
	
	
	///////////////////////////////////////
	
	
	TQGroupBox* colorGb = new TQGroupBox(vBox);
	colorGb->setTitle(i18n("Button contour colors:"));
	colorGb->setColumnLayout(0, TQt::Vertical );
	colorGb->layout()->setSpacing( 6 );
	colorGb->layout()->setMargin( 11 );
	
	TQGridLayout* gbLayout = new TQGridLayout( colorGb->layout(), 4, 2 );
	gbLayout->setAlignment( TQt::AlignTop );
	
	TQLabel* labelSC = new TQLabel(i18n("Standard color:"), colorGb);
	buttonContourColor = new KColorButton(colorGb);
	buttonContourColor->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Minimum);
	TQLabel* labelMC = new TQLabel(i18n("Mouseover color:"), colorGb);
	buttonMouseOverContourColor = new KColorButton(colorGb);
	TQLabel* labelPC = new TQLabel(i18n("Pressed color:"), colorGb);
	buttonPressedContourColor = new KColorButton(colorGb);
	
	useDominoStyleContourColors = new TQCheckBox( i18n("Use domino style contour colors"), colorGb );
	gbLayout->addMultiCellWidget(useDominoStyleContourColors, 0, 0, 0, 1);
	
	gbLayout->addWidget(labelSC, 1, 0);
	gbLayout->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Minimum, TQSizePolicy::Minimum) );
	gbLayout->addWidget(buttonContourColor, 1, 1);
	
	gbLayout->addWidget(labelMC, 2, 0);
	gbLayout->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Minimum, TQSizePolicy::Minimum) );
	gbLayout->addWidget(buttonMouseOverContourColor, 2, 1);
	
	gbLayout->addWidget(labelPC, 3, 0);
	gbLayout->addItem(new TQSpacerItem(20, 0, TQSizePolicy::Minimum, TQSizePolicy::Minimum) );
	gbLayout->addWidget(buttonPressedContourColor, 3, 1);
	
	
	
	
	
	
	
	
	
	///////////////////////////////////////
	
	// Load configuration options
	load(config);

	// Ensure we track user changes properly
	connect(customGradientColors, TQ_SIGNAL(toggled(bool)), topGradientColor, TQ_SLOT(setEnabled(bool)));
	connect(customGradientColors, TQ_SIGNAL(toggled(bool)), bottomGradientColor, TQ_SLOT(setEnabled(bool)));
	
	connect(customBorderColor, TQ_SIGNAL(toggled(bool)), borderColor, TQ_SLOT(setEnabled(bool)));
	connect(customButtonColor, TQ_SIGNAL(toggled(bool)), buttonColor, TQ_SLOT(setEnabled(bool)));
	connect(customButtonIconColor, TQ_SIGNAL(toggled(bool)), buttonIconColor, TQ_SLOT(setEnabled(bool)));
	
	connect(customGradientColors, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(topGradientColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	connect(bottomGradientColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	
	
	connect(customBorderColor, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(borderColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	
	connect(customButtonColor, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(buttonColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	connect(customButtonIconColor, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(buttonIconColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	
	connect(showInactiveButtons, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(showButtonIcons, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(darkFrame, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	
	connect(useDominoStyleContourColors, TQ_SIGNAL(clicked()), this, TQ_SLOT(loadButtonContourColors()));
	connect(useDominoStyleContourColors, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSelectionChanged()));
	connect(buttonContourColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	connect(buttonMouseOverContourColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	connect(buttonPressedContourColor, TQ_SIGNAL(changed(const TQColor&)), this, TQ_SLOT(slotSelectionChanged()));
	
	
	// Make the widgets visible in twindecoration valueChanged
	vBox->show();
}


DominoConfig::~DominoConfig()
{
	delete vBox;
	delete conf;
}


void DominoConfig::slotSelectionChanged()
{
	emit changed();
}


// Loads the configurable options from the twinrc config file
// It is passed the open config from twindecoration to improve efficiency
void DominoConfig::load(TDEConfig*)
{
	conf->setGroup("General");
	
	customBorderColor->setChecked(conf->readBoolEntry("customBorderColor", true));
	borderColor->setEnabled(customBorderColor->isChecked());
	borderColor->setColor(conf->readEntry("borderColor", "#777B7F"));
	customButtonColor->setChecked(conf->readBoolEntry( "customButtonColor", false));
	buttonColor->setEnabled(customButtonColor->isChecked());
	buttonColor->setColor(conf->readEntry("buttonColor", "#212121"));
	customButtonIconColor->setChecked(conf->readBoolEntry( "customButtonIconColor", false));
	buttonIconColor->setEnabled(customButtonIconColor->isChecked());
	buttonIconColor->setColor(conf->readEntry("buttonIconColor", "#000000"));
	
	customGradientColors->setChecked(conf->readBoolEntry( "customGradientColors", false));
	topGradientColor->setEnabled(customGradientColors->isChecked());
	bottomGradientColor->setEnabled(customGradientColors->isChecked());
	topGradientColor->setColor(conf->readEntry("topGradientColor", "#ffffff"));
	bottomGradientColor->setColor(conf->readEntry("bottomGradientColor", "#000000"));
	
	showInactiveButtons->setChecked(conf->readBoolEntry("showInactiveButtons", false));
	showButtonIcons->setChecked(conf->readBoolEntry("showButtonIcons", false));
	darkFrame->setChecked(conf->readBoolEntry("darkFrame", false));
	
	useDominoStyleContourColors->setChecked(conf->readBoolEntry("useDominoStyleContourColors", true));
	
	loadButtonContourColors();
	
}


// Saves the configurable options to the twinrc config file
void DominoConfig::save(TDEConfig*)
{
	conf->setGroup("General");
	
	conf->writeEntry("customBorderColor", customBorderColor->isChecked());
	conf->writeEntry("borderColor", borderColor->color().name());
	conf->writeEntry("customButtonColor", customButtonColor->isChecked());
	conf->writeEntry("buttonColor", buttonColor->color().name());
	conf->writeEntry("customButtonIconColor", customButtonIconColor->isChecked());
	conf->writeEntry("buttonIconColor", buttonIconColor->color().name());
	conf->writeEntry("showInactiveButtons", showInactiveButtons->isChecked());
	conf->writeEntry("showButtonIcons", showButtonIcons->isChecked());
	
	conf->writeEntry("customGradientColors", customGradientColors->isChecked());
	conf->writeEntry("topGradientColor", topGradientColor->color().name());
	conf->writeEntry("bottomGradientColor", bottomGradientColor->color().name());
	conf->writeEntry("darkFrame", darkFrame->isChecked());
	
	conf->writeEntry("useDominoStyleContourColors", useDominoStyleContourColors->isChecked());
	conf->writeEntry("buttonContourColor", buttonContourColor->color().name());
	conf->writeEntry("buttonMouseOverContourColor", buttonMouseOverContourColor->color().name());
	conf->writeEntry("buttonPressedContourColor", buttonPressedContourColor->color().name());
	
	conf->sync();
}


// Sets UI widget defaults which must correspond to style defaults
void DominoConfig::defaults()
{
	
	TQColor background = vBox->paletteBackgroundColor();
	
	customBorderColor->setChecked(true);
	borderColor->setColor("#777B7F");
	customButtonColor->setChecked(false);
	buttonColor->setColor("#212121");
	customButtonIconColor->setChecked(false);
	buttonIconColor->setColor("#000000");
	showInactiveButtons->setChecked(false);
	showButtonIcons->setChecked(false);
	customGradientColors->setChecked(false);
	topGradientColor->setColor("#ffffff");
	bottomGradientColor->setColor("#000000");
	darkFrame->setChecked(false);
	
	useDominoStyleContourColors->setChecked(true);
	buttonContourColor->setColor(background.dark(250).name());
	buttonMouseOverContourColor->setColor(background.dark(250).name());
	buttonPressedContourColor->setColor(background.dark(250).name());
	
}

void DominoConfig::loadButtonContourColors() {
	
	TQColor background = vBox->paletteBackgroundColor();
	if(useDominoStyleContourColors->isChecked()) {
		TQSettings s;
		buttonContourColor->setColor(s.readEntry("/domino/Settings/buttonContourColor", background.dark(250).name()));
		buttonMouseOverContourColor->setColor(s.readEntry("/domino/Settings/buttonMouseOverContourColor", background.dark(250).name()));
		buttonPressedContourColor->setColor(s.readEntry("/domino/Settings/buttonPressedContourColor", background.dark(250).name()));
	}
	else {
		buttonContourColor->setColor(conf->readEntry("buttonContourColor", background.dark(250).name()));
		buttonMouseOverContourColor->setColor(conf->readEntry("buttonMouseOverContourColor", background.dark(250).name()));
		buttonPressedContourColor->setColor(conf->readEntry("buttonPressedContourColor", background.dark(250).name()));
	}
	
}

#include "dominoConfig.moc"

