//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef COMMANDHANDLER_H
#define COMMANDHANDLER_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tdeio/jobclasses.h>
#include <tqfile.h>
#include <kurl.h>

class TDECmdLineArgs;
namespace TDEIO { class Job; }

class CommandHandler : public TQObject
{
    TQ_OBJECT

public:
    CommandHandler(TDECmdLineArgs *args);
    ~CommandHandler();
    void start();

private:
    KURL::List urlList(const TQStringList& list);
    void exitPrintUsage(const TQString& message);
    void list(const TQString& target);
    void get(const TQString& target);
    void put(const TQString& target);
    void mkdir(const TQString& target);
    void rmdir(const TQString& target);
    void del(const TQStringList& targets);
    void copy(const TQStringList& sources, const TQString& target);
    void commonConnect(TDEIO::Job* job);

    TQString command, origCommand, target, lastMessage;
    TQStringList targets, sources;
    TDEIO::Job* job;     
    int returnValue;
    TDECmdLineArgs *args;
    TQFile outFile, inFile;
    bool showProgressWindow, overwrite, iterate;

private slots:
    void slotFinished(TDEIO::Job *job);
    void slotEntries(TDEIO::Job* job, const TDEIO::UDSEntryList& list);
    void slotData(TDEIO::Job *, const TQByteArray &data);
    void slotDataReq(TDEIO::Job *, TQByteArray &data);
    void slotInfoMessage(TDEIO::Job* job,const TQString& msg);
    void slotPercent(TDEIO::Job* job, unsigned long percent);
};

#endif
