/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditstate.h"


// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditorstate.h"

namespace KMF {
KMFRuleOptionEditState::KMFRuleOptionEditState(TQObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditState::KMFRuleOptionEditState(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorState( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQ_SIGNAL(sigHideMe() ), 
		this,TQ_SLOT( slotShowOverview() ) );
}

KMFRuleOptionEditState::~KMFRuleOptionEditState() {}

void KMFRuleOptionEditState::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditState::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const TQString& KMFRuleOptionEditState::optionEditName() const {
	return *( new TQString( i18n("State Option") ) );
}
const TQString& KMFRuleOptionEditState::description() const {
	return *( new TQString( i18n("This plugin manages the State options for iptables rules.") ) );
}

void KMFRuleOptionEditState::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditState::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditState::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditState::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}


// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFRuleOptionEditStateFactory::s_instance = 0L;
// TDEAboutData* KMFRuleOptionEditStateFactory::s_about = 0L;

KMFRuleOptionEditStateFactory::KMFRuleOptionEditStateFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFRuleOptionEditStateFactory" );
}

TQObject* KMFRuleOptionEditStateFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditState( parent, name );
	emit objectCreated( obj );
	return obj;
}


// TDEInstance* KMFRuleOptionEditStateFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new TDEInstance( "KMFRuleOptionEditStateFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_state() {
		return new KMFRuleOptionEditStateFactory;
	}
}

}


#include "kmfruleoptioneditstate.moc"
